/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.net.SocketIOWithTimeout;

public class SocketOutputStream
extends OutputStream
implements WritableByteChannel {
    private Writer writer;

    public SocketOutputStream(WritableByteChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.writer = new Writer(channel, timeout);
    }

    public SocketOutputStream(Socket socket, long timeout) throws IOException {
        this(socket.getChannel(), timeout);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        while (buf.hasRemaining()) {
            try {
                if (this.write(buf) >= 0) continue;
                throw new IOException("The stream is closed");
            }
            catch (IOException e) {
                if (buf.capacity() > buf.remaining()) {
                    this.writer.close();
                }
                throw e;
            }
        }
    }

    public synchronized void close() throws IOException {
        this.writer.channel.close();
        this.writer.close();
    }

    public WritableByteChannel getChannel() {
        return this.writer.channel;
    }

    public boolean isOpen() {
        return this.writer.isOpen();
    }

    public int write(ByteBuffer src) throws IOException {
        return this.writer.doIO(src, 4);
    }

    private static class Writer
    extends SocketIOWithTimeout {
        WritableByteChannel channel;

        Writer(WritableByteChannel channel, long timeout) throws IOException {
            super((SelectableChannel)((Object)channel), timeout);
            this.channel = channel;
        }

        int performIO(ByteBuffer buf) throws IOException {
            return this.channel.write(buf);
        }
    }
}

