/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.record.compiler.CodeGenerator;
import org.apache.hadoop.record.compiler.JFile;
import org.apache.hadoop.record.compiler.JRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CppGenerator
extends CodeGenerator {
    CppGenerator() {
    }

    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        FileWriter cc = new FileWriter(name + ".cc");
        FileWriter hh = new FileWriter(name + ".hh");
        String fileName = new File(name).getName();
        hh.write("#ifndef __" + fileName.toUpperCase().replace('.', '_') + "__\n");
        hh.write("#define __" + fileName.toUpperCase().replace('.', '_') + "__\n");
        hh.write("#include \"recordio.hh\"\n");
        hh.write("#include \"recordTypeInfo.hh\"\n");
        Iterator<Object> iter = ilist.iterator();
        while (iter.hasNext()) {
            hh.write("#include \"" + iter.next().getName() + ".hh\"\n");
        }
        cc.write("#include \"" + fileName + ".hh\"\n");
        cc.write("#include \"utils.hh\"\n");
        iter = rlist.iterator();
        while (iter.hasNext()) {
            ((JRecord)iter.next()).genCppCode(hh, cc, options);
        }
        hh.write("#endif //" + fileName.toUpperCase().replace('.', '_') + "__\n");
        hh.close();
        cc.close();
    }
}

