/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFiles
implements Tool {
    private static final Log LOG = LogFactory.getLog(CopyFiles.class);
    private static final String NAME = "distcp";
    private static final String usage = "distcp [OPTIONS] <srcurl>* <desturl>\n\nOPTIONS:\n-p[rbugp]              Preserve status\n                       r: replication number\n                       b: block size\n                       u: user\n                       g: group\n                       p: permission\n                       -p alone is equivalent to -prbugp\n-i                     Ignore failures\n-log <logdir>          Write logs to <logdir>\n-overwrite             Overwrite destination\n-update                Overwrite if src size different from dst size\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n\nNOTE: if -overwrite or -update are set, each source URI is \n      interpreted as an isomorphic update to an existing directory.\nFor example:\nhadoop distcp -p -update \"hdfs://A:8020/user/foo/bar\" \"hdfs://B:8020/user/foo/baz\"\n\n     would update all descendants of 'baz' also in 'bar'; it would \n     *not* update /user/foo/baz/bar\n";
    private static final long BYTES_PER_MAP = 0x10000000L;
    private static final int MAX_MAPS_PER_NODE = 20;
    private static final int SYNC_FILE_MAX = 10;
    static final String TMP_DIR_LABEL = "distcp.tmp.dir";
    static final String DST_DIR_LABEL = "distcp.dest.path";
    static final String JOB_DIR_LABEL = "distcp.job.dir";
    static final String SRC_LIST_LABEL = "distcp.src.list";
    static final String SRC_COUNT_LABEL = "distcp.src.count";
    static final String TOTAL_SIZE_LABEL = "distcp.total.size";
    static final String DST_DIR_LIST_LABEL = "distcp.dst.dir.list";
    static final String PRESERVE_STATUS_LABEL = Options.PRESERVE_STATUS.propertyname + ".value";
    private JobConf conf;
    private static final Random RANDOM = new Random();

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public CopyFiles(Configuration conf) {
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Path> fetchFileList(Configuration conf, Path srcList) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = srcList.getFileSystem(conf);
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(fs.open(srcList)));
            String line = input.readLine();
            while (line != null) {
                result.add(new Path(line));
                line = input.readLine();
            }
        }
        catch (Throwable throwable) {
            CopyFiles.checkAndClose(input);
            throw throwable;
        }
        CopyFiles.checkAndClose(input);
        return result;
    }

    @Deprecated
    public static void copy(Configuration conf, String srcPath, String destPath, Path logPath, boolean srcAsList, boolean ignoreReadFailures) throws IOException {
        Path src = new Path(srcPath);
        ArrayList<Path> tmp = new ArrayList<Path>();
        if (srcAsList) {
            tmp.addAll(CopyFiles.fetchFileList(conf, src));
        } else {
            tmp.add(src);
        }
        EnumSet<Options> flags = ignoreReadFailures ? EnumSet.of(Options.IGNORE_READ_FAILURES) : EnumSet.noneOf(Options.class);
        CopyFiles.copy(conf, tmp, new Path(destPath), logPath, flags, null);
    }

    private static void checkSrcPath(Configuration conf, List<Path> srcPaths) throws IOException {
        ArrayList<IOException> rslt = new ArrayList<IOException>();
        for (Path p : srcPaths) {
            FileSystem fs = p.getFileSystem(conf);
            if (fs.exists(p)) continue;
            rslt.add(new IOException("Input source " + p + " does not exist."));
        }
        if (!rslt.isEmpty()) {
            throw new InvalidInputException(rslt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(Configuration conf, List<Path> srcPaths, Path destPath, Path logPath, EnumSet<Options> flags, String presevedAttributes) throws IOException {
        LOG.info((Object)("srcPaths=" + srcPaths));
        LOG.info((Object)("destPath=" + destPath));
        CopyFiles.checkSrcPath(conf, srcPaths);
        JobConf job = CopyFiles.createJobConf(conf);
        if (presevedAttributes != null) {
            job.set(PRESERVE_STATUS_LABEL, presevedAttributes);
        }
        try {
            CopyFiles.setup(conf, job, srcPaths, destPath, logPath, flags);
            JobClient.runJob(job);
            CopyFiles.finalize(conf, job, destPath, presevedAttributes);
        }
        finally {
            CopyFiles.fullyDelete(job.get(TMP_DIR_LABEL), job);
            CopyFiles.fullyDelete(job.get(JOB_DIR_LABEL), job);
        }
    }

    private static void updatePermissions(FileStatus src, FileStatus dst, EnumSet<FileAttribute> preseved, FileSystem destFileSys) throws IOException {
        String owner = null;
        String group = null;
        if (preseved.contains((Object)FileAttribute.USER) && !src.getOwner().equals(dst.getOwner())) {
            owner = src.getOwner();
        }
        if (preseved.contains((Object)FileAttribute.GROUP) && !src.getGroup().equals(dst.getGroup())) {
            group = src.getGroup();
        }
        if (owner != null || group != null) {
            destFileSys.setOwner(dst.getPath(), owner, group);
        }
        if (preseved.contains((Object)FileAttribute.PERMISSION) && !src.getPermission().equals(dst.getPermission())) {
            destFileSys.setPermission(dst.getPath(), src.getPermission());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finalize(Configuration conf, JobConf jobconf, Path destPath, String presevedAttributes) throws IOException {
        if (presevedAttributes == null) {
            return;
        }
        EnumSet<FileAttribute> preseved = FileAttribute.parse(presevedAttributes);
        if (!(preseved.contains((Object)FileAttribute.USER) || preseved.contains((Object)FileAttribute.GROUP) || preseved.contains((Object)FileAttribute.PERMISSION))) {
            return;
        }
        FileSystem dstfs = destPath.getFileSystem(conf);
        Path dstdirlist = new Path(jobconf.get(DST_DIR_LIST_LABEL));
        SequenceFile.Reader in = null;
        try {
            in = new SequenceFile.Reader(dstdirlist.getFileSystem(jobconf), dstdirlist, jobconf);
            Text dsttext = new Text();
            FilePair pair = new FilePair();
            while (in.next(dsttext, pair)) {
                Path absdst = new Path(destPath, pair.output);
                CopyFiles.updatePermissions(pair.input, dstfs.getFileStatus(absdst), preseved, dstfs);
            }
        }
        catch (Throwable throwable) {
            CopyFiles.checkAndClose(in);
            throw throwable;
        }
        CopyFiles.checkAndClose(in);
    }

    @Override
    public int run(String[] args) throws Exception {
        try {
            CommandArgument p = CommandArgument.valueOf(args, this.conf);
            CopyFiles.copy((Configuration)this.conf, p.srcs, p.dst, p.log, p.flags, p.presevedAttributes);
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(StringUtils.stringifyException(e) + "\n" + usage);
            ToolRunner.printGenericCommandUsage(System.err);
            return -1;
        }
        catch (DuplicationException e) {
            System.err.println(StringUtils.stringifyException(e));
            return -2;
        }
        catch (Exception e) {
            System.err.println("With failures, global counters are inaccurate; consider running with -i");
            System.err.println("Copy failed: " + StringUtils.stringifyException(e));
            return -999;
        }
    }

    public static void main(String[] args) throws Exception {
        JobConf job = new JobConf(CopyFiles.class);
        CopyFiles distcp = new CopyFiles(job);
        int res = ToolRunner.run(distcp, args);
        System.exit(res);
    }

    static String makeRelative(Path root, Path absPath) {
        if (!absPath.isAbsolute()) {
            throw new IllegalArgumentException("!absPath.isAbsolute(), absPath=" + absPath);
        }
        String p = absPath.toUri().getPath();
        StringTokenizer pathTokens = new StringTokenizer(p, "/");
        StringTokenizer rootTokens = new StringTokenizer(root.toUri().getPath(), "/");
        while (rootTokens.hasMoreTokens()) {
            if (rootTokens.nextToken().equals(pathTokens.nextToken())) continue;
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (pathTokens.hasMoreTokens()) {
            sb.append(pathTokens.nextToken());
            if (!pathTokens.hasMoreTokens()) continue;
            sb.append("/");
        }
        return sb.length() == 0 ? "." : sb.toString();
    }

    private static int getMapCount(long totalBytes, int numNodes) {
        int numMaps = (int)(totalBytes / 0x10000000L);
        numMaps = Math.min(numMaps, numNodes * 20);
        return Math.max(numMaps, 1);
    }

    static void fullyDelete(String dir, Configuration conf) throws IOException {
        if (dir != null) {
            Path tmp = new Path(dir);
            FileUtil.fullyDelete(tmp.getFileSystem(conf), tmp);
        }
    }

    private static JobConf createJobConf(Configuration conf) {
        JobConf jobconf = new JobConf(conf, CopyFiles.class);
        jobconf.setJobName(NAME);
        jobconf.setMapSpeculativeExecution(false);
        jobconf.setInputFormat(CopyInputFormat.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(Text.class);
        jobconf.setMapperClass(CopyFilesMapper.class);
        jobconf.setNumReduceTasks(0);
        return jobconf;
    }

    private static String getRandomId() {
        return Integer.toString(RANDOM.nextInt(Integer.MAX_VALUE), 36);
    }

    private static boolean setBooleans(JobConf jobConf, EnumSet<Options> flags) {
        boolean update = flags.contains((Object)Options.UPDATE);
        boolean overwrite = !update && flags.contains((Object)Options.OVERWRITE);
        jobConf.setBoolean(Options.UPDATE.propertyname, update);
        jobConf.setBoolean(Options.OVERWRITE.propertyname, overwrite);
        jobConf.setBoolean(Options.IGNORE_READ_FAILURES.propertyname, flags.contains((Object)Options.IGNORE_READ_FAILURES));
        jobConf.setBoolean(Options.PRESERVE_STATUS.propertyname, flags.contains((Object)Options.PRESERVE_STATUS));
        return update || overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setup(Configuration conf, JobConf jobConf, List<Path> srcPaths, Path destPath, Path logPath, EnumSet<Options> flags) throws IOException {
        jobConf.set(DST_DIR_LABEL, destPath.toUri().toString());
        boolean updateORoverwrite = CopyFiles.setBooleans(jobConf, flags);
        String randomId = CopyFiles.getRandomId();
        Path jobDirectory = new Path(jobConf.getSystemDir(), "distcp_" + randomId);
        jobConf.set(JOB_DIR_LABEL, jobDirectory.toString());
        FileSystem dstfs = destPath.getFileSystem(conf);
        boolean dstExists = dstfs.exists(destPath);
        boolean dstIsDir = false;
        if (dstExists) {
            dstIsDir = dstfs.getFileStatus(destPath).isDir();
        }
        if (logPath == null) {
            String filename = "_distcp_logs_" + randomId;
            if (!dstExists || !dstIsDir) {
                Path parent = destPath.getParent();
                if (!dstfs.exists(parent)) {
                    dstfs.mkdirs(parent);
                }
                logPath = new Path(parent, filename);
            } else {
                logPath = new Path(destPath, filename);
            }
        }
        FileOutputFormat.setOutputPath(jobConf, logPath);
        FileSystem jobfs = jobDirectory.getFileSystem(jobConf);
        Path srcfilelist = new Path(jobDirectory, "_distcp_src_files");
        jobConf.set(SRC_LIST_LABEL, srcfilelist.toString());
        SequenceFile.Writer src_writer = SequenceFile.createWriter(jobfs, jobConf, srcfilelist, LongWritable.class, FilePair.class, SequenceFile.CompressionType.NONE);
        Path dstfilelist = new Path(jobDirectory, "_distcp_dst_files");
        SequenceFile.Writer dst_writer = SequenceFile.createWriter(jobfs, jobConf, dstfilelist, Text.class, Text.class, SequenceFile.CompressionType.NONE);
        Path dstdirlist = new Path(jobDirectory, "_distcp_dst_dirs");
        jobConf.set(DST_DIR_LIST_LABEL, dstdirlist.toString());
        SequenceFile.Writer dir_writer = SequenceFile.createWriter(jobfs, jobConf, dstdirlist, Text.class, FilePair.class, SequenceFile.CompressionType.NONE);
        boolean special = srcPaths.size() == 1 && !dstExists || updateORoverwrite;
        int srcCount = 0;
        int cnsyncf = 0;
        int dirsyn = 0;
        long cbsize = 0L;
        long cbsyncs = 0L;
        try {
            for (Path src : srcPaths) {
                Path root;
                FileSystem fs = src.getFileSystem(conf);
                FileStatus srcfilestat = fs.getFileStatus(src);
                Path path = root = special && srcfilestat.isDir() ? src : src.getParent();
                if (srcfilestat.isDir()) {
                    ++srcCount;
                }
                Stack<FileStatus> pathstack = new Stack<FileStatus>();
                pathstack.push(srcfilestat);
                while (!pathstack.empty()) {
                    FileStatus cur = (FileStatus)pathstack.pop();
                    for (FileStatus child : fs.listStatus(cur.getPath())) {
                        ++srcCount;
                        if (child.isDir()) {
                            pathstack.push(child);
                        } else {
                            cbsize += child.getLen();
                            if (++cnsyncf > 10 || (cbsyncs += child.getLen()) > 0x10000000L) {
                                src_writer.sync();
                                dst_writer.sync();
                                cnsyncf = 0;
                                cbsyncs = 0L;
                            }
                        }
                        String dst = CopyFiles.makeRelative(root, child.getPath());
                        src_writer.append(new LongWritable(child.isDir() ? 0L : child.getLen()), new FilePair(child, dst));
                        dst_writer.append(new Text(dst), new Text(child.getPath().toString()));
                    }
                    if (!cur.isDir()) continue;
                    String dst = CopyFiles.makeRelative(root, cur.getPath());
                    dir_writer.append(new Text(dst), new FilePair(cur, dst));
                    if (++dirsyn <= 10) continue;
                    dirsyn = 0;
                    dir_writer.sync();
                }
            }
        }
        finally {
            CopyFiles.checkAndClose(src_writer);
            CopyFiles.checkAndClose(dst_writer);
            CopyFiles.checkAndClose(dir_writer);
        }
        if (!dstfs.exists(destPath) && srcCount > 1 && !dstfs.mkdirs(destPath)) {
            throw new IOException("Failed to create" + destPath);
        }
        CopyFiles.checkDuplication(jobfs, dstfilelist, new Path(jobDirectory, "_distcp_sorted"), conf);
        Path tmpDir = new Path(dstExists && !dstIsDir || !dstExists && srcCount == 1 ? destPath.getParent() : destPath, "_distcp_tmp_" + randomId);
        jobConf.set(TMP_DIR_LABEL, tmpDir.toUri().toString());
        LOG.info((Object)("srcCount=" + srcCount));
        jobConf.setInt(SRC_COUNT_LABEL, srcCount);
        jobConf.setLong(TOTAL_SIZE_LABEL, cbsize);
        jobConf.setNumMapTasks(CopyFiles.getMapCount(cbsize, new JobClient(jobConf).getClusterStatus().getTaskTrackers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDuplication(FileSystem fs, Path file, Path sorted, Configuration conf) throws IOException {
        SequenceFile.Reader in = null;
        try {
            SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, new Text.Comparator(), Text.class, Text.class, conf);
            sorter.sort(file, sorted);
            in = new SequenceFile.Reader(fs, sorted, conf);
            Text prevdst = null;
            Text curdst = new Text();
            Text prevsrc = null;
            Text cursrc = new Text();
            while (in.next(curdst, cursrc)) {
                if (prevdst != null && curdst.equals(prevdst)) {
                    throw new DuplicationException("Invalid input, there are duplicated files in the sources: " + prevsrc + ", " + cursrc);
                }
                prevdst = curdst;
                curdst = new Text();
                prevsrc = cursrc;
                cursrc = new Text();
            }
        }
        catch (Throwable throwable) {
            CopyFiles.checkAndClose(in);
            throw throwable;
        }
        CopyFiles.checkAndClose(in);
    }

    static boolean checkAndClose(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)StringUtils.stringifyException(ioe));
                return false;
            }
        }
        return true;
    }

    public static class DuplicationException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public static final int ERROR_CODE = -2;

        DuplicationException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandArgument {
        final List<Path> srcs;
        final Path dst;
        final Path log;
        final EnumSet<Options> flags;
        final String presevedAttributes;

        CommandArgument(List<Path> srcs, Path dst, Path log, EnumSet<Options> flags, String presevedAttributes) {
            this.srcs = srcs;
            this.dst = dst;
            this.log = log;
            this.flags = flags;
            this.presevedAttributes = presevedAttributes;
        }

        static CommandArgument valueOf(String[] args, Configuration conf) throws IOException {
            ArrayList<Path> srcs = new ArrayList<Path>();
            Path dst = null;
            Path log = null;
            EnumSet<Options> flags = EnumSet.noneOf(Options.class);
            String presevedAttributes = null;
            for (int idx = 0; idx < args.length; ++idx) {
                int i;
                Options[] opt = Options.values();
                for (i = 0; i < opt.length && !args[idx].startsWith(opt[i].cmd); ++i) {
                }
                if (i < opt.length) {
                    flags.add(opt[i]);
                    if (opt[i] != Options.PRESERVE_STATUS) continue;
                    presevedAttributes = args[idx].substring(2);
                    FileAttribute.parse(presevedAttributes);
                    continue;
                }
                if ("-f".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("urilist_uri not specified in -f");
                    }
                    srcs.addAll(CopyFiles.fetchFileList(conf, new Path(args[idx])));
                    continue;
                }
                if ("-log".equals(args[idx])) {
                    if (++idx == args.length) {
                        throw new IllegalArgumentException("logdir not specified in -log");
                    }
                    log = new Path(args[idx]);
                    continue;
                }
                if (45 == args[idx].codePointAt(0)) {
                    throw new IllegalArgumentException("Invalid switch " + args[idx]);
                }
                if (idx == args.length - 1) {
                    dst = new Path(args[idx]);
                    continue;
                }
                srcs.add(new Path(args[idx]));
            }
            if (srcs.isEmpty() || dst == null) {
                throw new IllegalArgumentException("Missing " + (dst == null ? "dst path" : "src"));
            }
            if (flags.contains((Object)Options.OVERWRITE) && flags.contains((Object)Options.UPDATE)) {
                throw new IllegalArgumentException("Conflicting overwrite policies");
            }
            return new CommandArgument(srcs, dst, log, flags, presevedAttributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CopyFilesMapper
    implements Mapper<LongWritable, FilePair, WritableComparable, Text> {
        private int sizeBuf = 131072;
        private FileSystem destFileSys = null;
        private boolean ignoreReadFailures;
        private boolean preserve_status;
        private EnumSet<FileAttribute> preseved;
        private boolean overwrite;
        private boolean update;
        private Path destPath = null;
        private byte[] buffer = null;
        private JobConf job;
        private int failcount = 0;
        private int skipcount = 0;
        private int copycount = 0;

        CopyFilesMapper() {
        }

        private String getCountString() {
            return "Copied: " + this.copycount + " Skipped: " + this.skipcount + " Failed: " + this.failcount;
        }

        private void updateStatus(Reporter reporter) {
            reporter.setStatus(this.getCountString());
        }

        private boolean needsUpdate(FileStatus src, FileStatus dst) {
            return this.update && src.getLen() != dst.getLen();
        }

        private FSDataOutputStream create(Path f, Reporter reporter, FileStatus srcstat) throws IOException {
            if (!this.preserve_status) {
                return this.destFileSys.create(f, reporter);
            }
            FsPermission permission = this.preseved.contains((Object)FileAttribute.PERMISSION) ? srcstat.getPermission() : null;
            short replication = this.preseved.contains((Object)FileAttribute.REPLICATION) ? srcstat.getReplication() : this.destFileSys.getDefaultReplication();
            long blockSize = this.preseved.contains((Object)FileAttribute.BLOCK_SIZE) ? srcstat.getBlockSize() : this.destFileSys.getDefaultBlockSize();
            return this.destFileSys.create(f, permission, true, this.sizeBuf, replication, blockSize, reporter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(FileStatus srcstat, Path relativedst, OutputCollector<WritableComparable, Text> outc, Reporter reporter) throws IOException {
            Path dstparent;
            Path absdst = new Path(this.destPath, relativedst);
            int totfiles = this.job.getInt(CopyFiles.SRC_COUNT_LABEL, -1);
            assert (totfiles >= 0) : "Invalid file count " + totfiles;
            if (srcstat.isDir()) {
                if (this.destFileSys.exists(absdst)) {
                    if (!this.destFileSys.getFileStatus(absdst).isDir()) {
                        throw new IOException("Failed to mkdirs: " + absdst + " is a file.");
                    }
                } else if (!this.destFileSys.mkdirs(absdst)) {
                    throw new IOException("Failed to mkdirs " + absdst);
                }
                return;
            }
            if (this.destFileSys.exists(absdst) && !this.overwrite && !this.needsUpdate(srcstat, this.destFileSys.getFileStatus(absdst))) {
                outc.collect(null, new Text("SKIP: " + srcstat.getPath()));
                ++this.skipcount;
                reporter.incrCounter(Counter.SKIP, 1L);
                this.updateStatus(reporter);
                return;
            }
            Path tmpfile = new Path(this.job.get(CopyFiles.TMP_DIR_LABEL), relativedst);
            long cbcopied = 0L;
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                int cbread;
                in = srcstat.getPath().getFileSystem(this.job).open(srcstat.getPath());
                reporter.incrCounter(Counter.BYTESEXPECTED, srcstat.getLen());
                out = this.create(tmpfile, reporter, srcstat);
                while ((cbread = in.read(this.buffer)) >= 0) {
                    out.write(this.buffer, 0, cbread);
                    reporter.setStatus(String.format("%.2f ", (double)(cbcopied += (long)cbread) * 100.0 / (double)srcstat.getLen()) + absdst + " [ " + StringUtils.humanReadableInt(cbcopied) + " / " + StringUtils.humanReadableInt(srcstat.getLen()) + " ]");
                }
            }
            catch (Throwable throwable) {
                CopyFiles.checkAndClose(in);
                CopyFiles.checkAndClose(out);
                throw throwable;
            }
            CopyFiles.checkAndClose(in);
            CopyFiles.checkAndClose(out);
            if (cbcopied != srcstat.getLen()) {
                throw new IOException("File size not matched: copied " + CopyFilesMapper.bytesString(cbcopied) + " to tmpfile (=" + tmpfile + ") but expected " + CopyFilesMapper.bytesString(srcstat.getLen()) + " from " + srcstat.getPath());
            }
            if (!(totfiles != 1 || this.destFileSys.exists(dstparent = absdst.getParent()) && this.destFileSys.getFileStatus(dstparent).isDir())) {
                absdst = dstparent;
            }
            if (this.destFileSys.exists(absdst) && this.destFileSys.getFileStatus(absdst).isDir()) {
                throw new IOException(absdst + " is a directory");
            }
            if (!this.destFileSys.mkdirs(absdst.getParent())) {
                throw new IOException("Failed to craete parent dir: " + absdst.getParent());
            }
            this.rename(tmpfile, absdst);
            FileStatus dststat = this.destFileSys.getFileStatus(absdst);
            if (dststat.getLen() != srcstat.getLen()) {
                this.destFileSys.delete(absdst, false);
                throw new IOException("File size not matched: copied " + CopyFilesMapper.bytesString(dststat.getLen()) + " to dst (=" + absdst + ") but expected " + CopyFilesMapper.bytesString(srcstat.getLen()) + " from " + srcstat.getPath());
            }
            this.updatePermissions(srcstat, dststat);
            ++this.copycount;
            reporter.incrCounter(Counter.BYTESCOPIED, cbcopied);
            reporter.incrCounter(Counter.COPY, 1L);
            this.updateStatus(reporter);
        }

        private void rename(Path tmp, Path dst) throws IOException {
            try {
                if (this.destFileSys.exists(dst)) {
                    this.destFileSys.delete(dst, true);
                }
                if (!this.destFileSys.rename(tmp, dst)) {
                    throw new IOException();
                }
            }
            catch (IOException cause) {
                throw (IOException)new IOException("Fail to rename tmp file (=" + tmp + ") to destination file (=" + dst + ")").initCause(cause);
            }
        }

        private void updatePermissions(FileStatus src, FileStatus dst) throws IOException {
            if (this.preserve_status) {
                CopyFiles.updatePermissions(src, dst, this.preseved, this.destFileSys);
            }
        }

        static String bytesString(long b) {
            return b + " bytes (" + StringUtils.humanReadableInt(b) + ")";
        }

        @Override
        public void configure(JobConf job) {
            this.destPath = new Path(job.get(CopyFiles.DST_DIR_LABEL, "/"));
            try {
                this.destFileSys = this.destPath.getFileSystem(job);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to get the named file system.", ex);
            }
            this.sizeBuf = job.getInt("copy.buf.size", 131072);
            this.buffer = new byte[this.sizeBuf];
            this.ignoreReadFailures = job.getBoolean(Options.IGNORE_READ_FAILURES.propertyname, false);
            this.preserve_status = job.getBoolean(Options.PRESERVE_STATUS.propertyname, false);
            if (this.preserve_status) {
                this.preseved = FileAttribute.parse(job.get(PRESERVE_STATUS_LABEL));
            }
            this.update = job.getBoolean(Options.UPDATE.propertyname, false);
            this.overwrite = !this.update && job.getBoolean(Options.OVERWRITE.propertyname, false);
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map(LongWritable key, FilePair value, OutputCollector<WritableComparable, Text> out, Reporter reporter) throws IOException {
            FileStatus srcstat = value.input;
            Path dstpath = new Path(value.output);
            try {
                this.copy(srcstat, dstpath, out, reporter);
            }
            catch (IOException e) {
                ++this.failcount;
                reporter.incrCounter(Counter.FAIL, 1L);
                this.updateStatus(reporter);
                String sfailure = "FAIL " + dstpath + " : " + StringUtils.stringifyException(e);
                out.collect(null, new Text(sfailure));
                LOG.info((Object)sfailure);
                try {
                    for (int i = 0; i < 3; ++i) {
                        block11: {
                            try {
                                if (!this.destFileSys.delete(dstpath, true)) break block11;
                                break;
                            }
                            catch (Throwable ex) {
                                LOG.debug((Object)"Ignoring cleanup exception", ex);
                            }
                        }
                        this.updateStatus(reporter);
                        Thread.sleep(3000L);
                    }
                }
                catch (InterruptedException inte) {
                    throw (IOException)new IOException().initCause(inte);
                }
            }
            finally {
                this.updateStatus(reporter);
            }
        }

        @Override
        public void close() throws IOException {
            if (0 == this.failcount || this.ignoreReadFailures) {
                return;
            }
            throw new IOException(this.getCountString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CopyInputFormat
    implements InputFormat<Text, Text> {
        CopyInputFormat() {
        }

        @Override
        public void validateInput(JobConf job) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            int cnfiles = job.getInt(CopyFiles.SRC_COUNT_LABEL, -1);
            long cbsize = job.getLong(CopyFiles.TOTAL_SIZE_LABEL, -1L);
            String srcfilelist = job.get(CopyFiles.SRC_LIST_LABEL, "");
            if (cnfiles < 0 || cbsize < 0L || "".equals(srcfilelist)) {
                throw new RuntimeException("Invalid metadata: #files(" + cnfiles + ") total_size(" + cbsize + ") listuri(" + srcfilelist + ")");
            }
            Path src = new Path(srcfilelist);
            FileSystem fs = src.getFileSystem(job);
            FileStatus srcst = fs.getFileStatus(src);
            ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
            LongWritable key = new LongWritable();
            FilePair value = new FilePair();
            long targetsize = cbsize / (long)numSplits;
            long pos = 0L;
            long last = 0L;
            long acc = 0L;
            long cbrem = srcst.getLen();
            SequenceFile.Reader sl = null;
            try {
                sl = new SequenceFile.Reader(fs, src, job);
                while (sl.next(key, value)) {
                    if (acc + key.get() > targetsize && acc != 0L) {
                        long splitsize = last - pos;
                        splits.add(new FileSplit(src, pos, splitsize, (String[])null));
                        cbrem -= splitsize;
                        pos = last;
                        acc = 0L;
                    }
                    acc += key.get();
                    last = sl.getPosition();
                }
            }
            catch (Throwable throwable) {
                CopyFiles.checkAndClose(sl);
                throw throwable;
            }
            CopyFiles.checkAndClose(sl);
            if (cbrem != 0L) {
                splits.add(new FileSplit(src, pos, cbrem, (String[])null));
            }
            return splits.toArray(new FileSplit[splits.size()]);
        }

        @Override
        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new SequenceFileRecordReader<Text, Text>(job, (FileSplit)split);
        }
    }

    static class FilePair
    implements Writable {
        FileStatus input = new FileStatus();
        String output;

        FilePair() {
        }

        FilePair(FileStatus input, String output) {
            this.input = input;
            this.output = output;
        }

        public void readFields(DataInput in) throws IOException {
            this.input.readFields(in);
            this.output = Text.readString(in);
        }

        public void write(DataOutput out) throws IOException {
            this.input.write(out);
            Text.writeString(out, this.output);
        }

        public String toString() {
            return this.input + " : " + this.output;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileAttribute {
        BLOCK_SIZE,
        REPLICATION,
        USER,
        GROUP,
        PERMISSION;

        final char symbol = this.toString().toLowerCase().charAt(0);

        static EnumSet<FileAttribute> parse(String s) {
            if (s == null || s.length() == 0) {
                return EnumSet.allOf(FileAttribute.class);
            }
            EnumSet<FileAttribute> set = EnumSet.noneOf(FileAttribute.class);
            FileAttribute[] attributes = FileAttribute.values();
            for (char c : s.toCharArray()) {
                int i;
                for (i = 0; i < attributes.length && c != attributes[i].symbol; ++i) {
                }
                if (i < attributes.length) {
                    if (set.contains((Object)attributes[i])) {
                        throw new IllegalArgumentException("There are more than one '" + attributes[i].symbol + "' in " + s);
                    }
                } else {
                    throw new IllegalArgumentException("'" + c + "' in " + s + " is undefined.");
                }
                set.add(attributes[i]);
            }
            return set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Options {
        IGNORE_READ_FAILURES("-i", "distcp.ignore.read.failures"),
        PRESERVE_STATUS("-p", "distcp.preserve.status"),
        OVERWRITE("-overwrite", "distcp.overwrite.always"),
        UPDATE("-update", "distcp.overwrite.ifnewer");

        final String cmd;
        final String propertyname;

        private Options(String cmd, String propertyname) {
            this.cmd = cmd;
            this.propertyname = propertyname;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Counter {
        COPY,
        SKIP,
        FAIL,
        BYTESCOPIED,
        BYTESEXPECTED;

    }
}

