/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.apache.crimson.parser.AttributesEx;
import org.apache.crimson.tree.AttributeNode;
import org.apache.crimson.tree.AttributeNode1;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.NodeBase;
import org.apache.crimson.tree.XmlWritable;
import org.apache.crimson.tree.XmlWriteContext;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private Element ownerElement;

    private AttributeSet() {
    }

    AttributeSet(Element ownerElement) {
        this.list = new Vector(5);
        this.ownerElement = ownerElement;
    }

    AttributeSet(AttributeSet original, boolean deep) {
        int size = original.getLength();
        this.list = new Vector(size);
        int i = 0;
        while (i < size) {
            Node node = original.item(i);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attr = (AttributeNode)node;
            node = attr.cloneAttributeNode(deep);
            this.list.addElement(node);
            ++i;
        }
    }

    AttributeSet(AttributeSet original) {
        int size = original.getLength();
        this.list = new Vector(size);
        int i = 0;
        while (i < size) {
            Node node = original.item(i);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            AttributeNode attr = (AttributeNode)node;
            if (attr.getSpecified()) {
                node = attr.cloneAttributeNode(true);
                this.list.addElement(node);
            }
            ++i;
        }
        this.list.trimToSize();
    }

    static AttributeSet createAttributeSet2(Attributes source) throws DOMException {
        AttributeSet retval = new AttributeSet();
        int len = source.getLength();
        AttributesEx ex = null;
        retval.list = new Vector(len);
        if (source instanceof AttributesEx) {
            ex = (AttributesEx)source;
        }
        int i = 0;
        while (i < len) {
            String uri;
            String qName = source.getQName(i);
            if ("xmlns".equals(qName) || "xmlns".equals(XmlNames.getPrefix(qName))) {
                uri = "http://www.w3.org/2000/xmlns/";
            } else {
                uri = source.getURI(i);
                if ("".equals(uri)) {
                    uri = null;
                }
            }
            AttributeNode attrNode = new AttributeNode(uri, qName, source.getValue(i), ex == null ? true : ex.isSpecified(i), ex == null ? null : ex.getDefault(i));
            retval.list.addElement(attrNode);
            ++i;
        }
        return retval;
    }

    static AttributeSet createAttributeSet1(Attributes source) throws DOMException {
        AttributeSet retval = new AttributeSet();
        int len = source.getLength();
        AttributesEx ex = null;
        retval.list = new Vector(len);
        if (source instanceof AttributesEx) {
            ex = (AttributesEx)source;
        }
        int i = 0;
        while (i < len) {
            AttributeNode1 attrNode1 = new AttributeNode1(source.getQName(i), source.getValue(i), ex == null ? true : ex.isSpecified(i), ex == null ? null : ex.getDefault(i));
            retval.list.addElement(attrNode1);
            ++i;
        }
        return retval;
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void setReadonly() {
        this.readonly = true;
        int i = 0;
        while (i < this.list.size()) {
            ((AttributeNode)this.list.elementAt(i)).setReadonly(true);
            ++i;
        }
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int i = 0;
        while (i < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(i)).isReadonly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setOwnerElement(Element e) {
        if (e != null && this.ownerElement != null) {
            throw new IllegalStateException(((NodeBase)((Object)e)).getMessage("A-004"));
        }
        this.ownerElement = e;
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode node = (AttributeNode)this.list.elementAt(i);
            node.setOwnerElement(null);
            node.setOwnerElement(e);
            ++i;
        }
    }

    String getValue(String name) {
        Attr attr = (Attr)this.getNamedItem(name);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node getNamedItem(String name) {
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            Node value = this.item(i);
            if (value.getNodeName().equals(name)) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (localName == null) {
            return null;
        }
        int i = 0;
        while (i < this.list.size()) {
            String iNamespaceURI;
            Node value = this.item(i);
            String iLocalName = value.getLocalName();
            if (localName.equals(iLocalName) && (namespaceURI == (iNamespaceURI = value.getNamespaceURI()) || namespaceURI != null && namespaceURI.equals(iNamespaceURI))) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(index);
    }

    public Node removeNamedItem(String name) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        int i = 0;
        while (i < this.list.size()) {
            Node value = (Node)this.list.elementAt(i);
            if (value.getNodeName().equals(name)) {
                this.list.removeElementAt(i);
                AttributeNode attr = (AttributeNode)value;
                String defaultValue = attr.getDefaultValue();
                if (defaultValue != null) {
                    AttributeNode newAttr = attr.cloneAttributeNode(true);
                    newAttr.setOwnerElement(attr.getOwnerElement());
                    newAttr.setValue(defaultValue);
                    newAttr.setSpecified(false);
                    this.list.addElement(newAttr);
                }
                attr.setOwnerElement(null);
                return attr;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (localName == null) {
            throw new DomEx(8);
        }
        int i = 0;
        while (i < this.list.size()) {
            String iNamespaceURI;
            Node value = (Node)this.list.elementAt(i);
            String iLocalName = value.getLocalName();
            if (localName.equals(iLocalName) && (namespaceURI == (iNamespaceURI = value.getNamespaceURI()) || namespaceURI != null && namespaceURI.equals(iNamespaceURI))) {
                this.list.removeElementAt(i);
                AttributeNode attr = (AttributeNode)value;
                String defaultValue = attr.getDefaultValue();
                if (defaultValue != null) {
                    AttributeNode newAttr = attr.cloneAttributeNode(true);
                    newAttr.setOwnerElement(attr.getOwnerElement());
                    newAttr.setValue(defaultValue);
                    newAttr.setSpecified(false);
                    this.list.addElement(newAttr);
                }
                attr.setOwnerElement(null);
                return attr;
            }
            ++i;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node value) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(value instanceof AttributeNode) || value.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode att = (AttributeNode)value;
        if (att.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode oldAtt = (AttributeNode)this.item(i);
            if (oldAtt.getNodeName().equals(value.getNodeName())) {
                if (oldAtt.isReadonly()) {
                    throw new DomEx(7);
                }
                att.setOwnerElement(this.ownerElement);
                this.list.setElementAt(att, i);
                oldAtt.setOwnerElement(null);
                return oldAtt;
            }
            ++i;
        }
        att.setOwnerElement(this.ownerElement);
        this.list.addElement(value);
        return null;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(arg instanceof AttributeNode) || arg.getOwnerDocument() != this.ownerElement.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attr = (AttributeNode)arg;
        if (attr.getOwnerElement() != null) {
            throw new DomEx(10);
        }
        String localName = attr.getLocalName();
        String namespaceURI = attr.getNamespaceURI();
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode oldNode = (AttributeNode)this.item(i);
            String iLocalName = oldNode.getLocalName();
            String iNamespaceURI = oldNode.getNamespaceURI();
            if ((localName == iLocalName || localName != null && localName.equals(iLocalName)) && (namespaceURI == iNamespaceURI || namespaceURI != null && namespaceURI.equals(iNamespaceURI))) {
                if (oldNode.isReadonly()) {
                    throw new DomEx(7);
                }
                attr.setOwnerElement(this.ownerElement);
                this.list.setElementAt(attr, i);
                oldNode.setOwnerElement(null);
                return oldNode;
            }
            ++i;
        }
        attr.setOwnerElement(this.ownerElement);
        this.list.addElement(attr);
        return null;
    }

    public void writeXml(XmlWriteContext context) throws IOException {
        Writer out = context.getWriter();
        int length = this.list.size();
        int i = 0;
        while (i < length) {
            AttributeNode tmp = (AttributeNode)this.list.elementAt(i);
            if (tmp.getSpecified()) {
                out.write(32);
                tmp.writeXml(context);
            }
            ++i;
        }
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
    }

    public String toString() {
        try {
            CharArrayWriter w = new CharArrayWriter();
            XmlWriteContext x = new XmlWriteContext(w);
            this.writeXml(x);
            return w.toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }
}

