/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import org.h2.security.SecureSocketFactory;
import org.h2.util.ByteUtils;

public class SecureKeyStoreBuilder {
    public static void main(String[] a) throws Exception {
        String password = "h2pass";
        KeyStore store = SecureSocketFactory.getKeyStore(password);
        SecureKeyStoreBuilder.printKeystore(store, password);
    }

    private static void printKeystore(KeyStore store, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateEncodingException {
        System.out.println("KeyStore store = KeyStore.getInstance(\"" + store.getType() + "\");");
        System.out.println("store.load(null, password.toCharArray());");
        Enumeration<String> en = store.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            Key key = store.getKey(alias, password.toCharArray());
            System.out.println("KeyFactory keyFactory = KeyFactory.getInstance(\"" + key.getAlgorithm() + "\");");
            System.out.println("store.load(null, password.toCharArray());");
            String pkFormat = key.getFormat();
            String encoded = ByteUtils.convertBytesToString(key.getEncoded());
            System.out.println(pkFormat + "EncodedKeySpec keySpec = new " + pkFormat + "EncodedKeySpec(getBytes(\"" + encoded + "\"));");
            System.out.println("PrivateKey privateKey = keyFactory.generatePrivate(keySpec);");
            System.out.println("Certificate[] certs = new Certificate[]{");
            Certificate[] certs = store.getCertificateChain(alias);
            for (int i = 0; i < certs.length; ++i) {
                Certificate cert = certs[i];
                System.out.println("  CertificateFactory.getInstance(\"" + cert.getType() + "\").");
                String enc = ByteUtils.convertBytesToString(cert.getEncoded());
                System.out.println("        generateCertificate(new ByteArrayInputStream(getBytes(\"" + enc + "\"))),");
            }
            System.out.println("};");
            System.out.println("store.setKeyEntry(\"" + alias + "\", privateKey, password.toCharArray(), certs);");
        }
    }
}

