/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.DOMException;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.XPathVisitor;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element
extends Node {
    private Node firstChild_ = null;
    private Node lastChild_ = null;
    private final Dictionary attributes_ = new Hashtable();
    private final Vector attributeNames_ = new Vector();
    private final Vector children_ = new Vector();
    private final Dictionary childrenSet_ = new Hashtable();
    private String tagName_ = null;

    public Element(String string) {
        this.tagName_ = string;
    }

    Element() {
    }

    public Object clone() {
        return this.cloneElement(true);
    }

    public Element cloneShallow() {
        return this.cloneElement(false);
    }

    public Element cloneElement(boolean bl) {
        Object object;
        Element element = new Element(this.tagName_);
        Enumeration enumeration = this.attributeNames_.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            element.setAttribute((String)object, (String)this.attributes_.get(object));
        }
        if (bl) {
            object = this.firstChild_;
            while (object != null) {
                element.appendChild((Node)((Node)object).clone());
                object = ((Node)object).getNextSibling();
            }
        }
        return element;
    }

    public String getTagName() {
        return this.tagName_;
    }

    public void setTagName(String string) {
        this.tagName_ = string;
        this.notifyObservers();
    }

    public Node getFirstChild() {
        return this.firstChild_;
    }

    public Node getLastChild() {
        return this.lastChild_;
    }

    public Enumeration getAttributeNames() {
        return this.attributeNames_.elements();
    }

    public String getAttribute(String string) {
        return (String)this.attributes_.get(string);
    }

    public void setAttribute(String string, String string2) {
        if (this.attributes_.get(string) == null) {
            this.attributeNames_.addElement(string);
        }
        this.attributes_.put(string, string2);
        this.notifyObservers();
    }

    public void removeAttribute(String string) {
        this.attributes_.remove(string);
        this.attributeNames_.removeElement(string);
        this.notifyObservers();
    }

    void appendChildNoChecking(Node node) {
        Object v = this.childrenSet_.get(node);
        if (v != null) {
            this.removeChildNoChecking(node);
        }
        node.insertAtEndOfLinkedList(this.lastChild_);
        if (this.firstChild_ == null) {
            this.firstChild_ = node;
        }
        node.setParentNode(this);
        this.children_.addElement(node);
        this.childrenSet_.put(node, node);
        this.lastChild_ = node;
        node.setOwnerDocument(this.getOwnerDocument());
    }

    public void appendChild(Node node) {
        if (!this.canHaveAsDescendent(node)) {
            node = (Element)node.clone();
        }
        this.appendChildNoChecking(node);
        this.notifyObservers();
    }

    boolean canHaveAsDescendent(Node node) {
        if (node == this) {
            return false;
        }
        Element element = this.getParentNode();
        if (element == null) {
            return true;
        }
        return element.canHaveAsDescendent(node);
    }

    private boolean removeChildNoChecking(Node node) {
        int n = 0;
        Node node2 = this.firstChild_;
        while (node2 != null) {
            if (node2.equals(node)) {
                if (this.firstChild_ == node2) {
                    this.firstChild_ = node2.getNextSibling();
                }
                if (this.lastChild_ == node2) {
                    this.lastChild_ = node2.getPreviousSibling();
                }
                node2.removeFromLinkedList();
                node2.setParentNode(null);
                this.children_.removeElementAt(n);
                this.childrenSet_.remove(node2);
                node2.setOwnerDocument(null);
                return true;
            }
            ++n;
            node2 = node2.getNextSibling();
        }
        return false;
    }

    public void removeChild(Node node) throws DOMException {
        boolean bl = this.removeChildNoChecking(node);
        if (!bl) {
            throw new DOMException(8, "Cannot find " + node + " in " + this);
        }
        this.notifyObservers();
    }

    public void replaceChild(Element element, Node node) throws DOMException {
        this.replaceChild_(element, node);
        this.notifyObservers();
    }

    public void replaceChild(Text text, Node node) throws DOMException {
        this.replaceChild_(text, node);
        this.notifyObservers();
    }

    private void replaceChild_(Node node, Node node2) throws DOMException {
        int n = 0;
        Node node3 = this.firstChild_;
        while (node3 != null) {
            if (node3 == node2) {
                if (this.firstChild_ == node2) {
                    this.firstChild_ = node;
                }
                if (this.lastChild_ == node2) {
                    this.lastChild_ = node;
                }
                node2.replaceInLinkedList(node);
                node.setParentNode(this);
                node2.setParentNode(null);
                this.children_.setElementAt(node, n);
                this.childrenSet_.remove(node2);
                this.childrenSet_.put(node, node);
                return;
            }
            ++n;
            node3 = node3.getNextSibling();
        }
        throw new DOMException(8, "Cannot find " + node2 + " in " + this);
    }

    void toString(Writer writer) throws IOException {
        Node node = this.firstChild_;
        while (node != null) {
            node.toString(writer);
            node = node.getNextSibling();
        }
    }

    public void toXml(Writer writer) throws IOException {
        Object object;
        writer.write("<" + this.tagName_);
        Enumeration enumeration = this.attributeNames_.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)this.attributes_.get(object);
            writer.write(" " + (String)object + "=\"");
            Node.htmlEncode(writer, string);
            writer.write("\"");
        }
        if (this.firstChild_ == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            object = this.firstChild_;
            while (object != null) {
                ((Node)object).toXml(writer);
                object = ((Node)object).getNextSibling();
            }
            writer.write("</" + this.tagName_ + ">");
        }
    }

    private XPathVisitor visitor(String string, boolean bl) throws XPathException {
        XPath xPath = XPath.get(string);
        if (xPath.isStringValue() != bl) {
            String string2 = bl ? "evaluates to element not string" : "evaluates to string not element";
            throw new XPathException(xPath, "\"" + xPath + "\" evaluates to " + string2);
        }
        return new XPathVisitor(this, xPath);
    }

    public Enumeration xpathSelectElements(String string) throws ParseException {
        try {
            return this.visitor(string, false).getResultEnumeration();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public Enumeration xpathSelectStrings(String string) throws ParseException {
        try {
            return this.visitor(string, true).getResultEnumeration();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public boolean xpathEnsure(String string) throws ParseException {
        try {
            Object object;
            Element element;
            if (this.xpathSelectElement(string) != null) {
                return false;
            }
            XPath xPath = XPath.get(string);
            int n = 0;
            Enumeration enumeration = xPath.getSteps();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            Step[] stepArray = new Step[n - 1];
            Enumeration enumeration2 = xPath.getSteps();
            int n2 = 0;
            while (n2 < stepArray.length) {
                stepArray[n2] = (Step)enumeration2.nextElement();
                ++n2;
            }
            Step step = (Step)enumeration2.nextElement();
            if (stepArray.length == 0) {
                element = this;
            } else {
                object = XPath.get(xPath.isAbsolute(), stepArray).toString();
                this.xpathEnsure(((String)object).toString());
                element = this.xpathSelectElement((String)object);
            }
            object = this.makeMatching(element, step, string);
            element.appendChildNoChecking((Node)object);
            return true;
        }
        catch (XPathException xPathException) {
            throw new ParseException(string, xPathException);
        }
    }

    public Element xpathSelectElement(String string) throws ParseException {
        try {
            return this.visitor(string, false).getFirstResultElement();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public String xpathSelectString(String string) throws ParseException {
        try {
            return this.visitor(string, true).getFirstResultString();
        }
        catch (XPathException xPathException) {
            throw new ParseException("XPath problem", xPathException);
        }
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Element)) {
            return false;
        }
        Element element = (Element)object;
        if (!this.tagName_.equals(element.tagName_)) {
            return false;
        }
        if (this.children_.size() != element.children_.size()) {
            return false;
        }
        if (this.attributes_.size() != element.attributes_.size()) {
            return false;
        }
        Enumeration enumeration = this.attributes_.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            object3 = (String)enumeration.nextElement();
            object2 = (String)this.attributes_.get(object3);
            if (((String)object2).equals(string = (String)element.attributes_.get(object3))) continue;
            return false;
        }
        object3 = this.firstChild_;
        object2 = element.firstChild_;
        while (object3 != null) {
            if (!object3.equals(object2)) {
                return false;
            }
            object3 = ((Node)object3).getNextSibling();
            object2 = ((Node)object2).getNextSibling();
        }
        return true;
    }
}

