/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.shopping.xmlparser;

import com.yahoo.shopping.Catalog;
import com.yahoo.shopping.Merchant;
import com.yahoo.shopping.Offer;
import com.yahoo.shopping.ProductSearchResults;
import com.yahoo.shopping.Specification;
import com.yahoo.shopping.Thumbnail;
import com.yahoo.shopping.UserRating;
import com.yahoo.xml.XmlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XmlParserProductSearchResults
implements ProductSearchResults {
    private Map root;
    private List results;

    public XmlParserProductSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(this.root, "/ResultSet/Result");
        if (list != null) {
            this.results = new ArrayList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Map map2 = (Map)list.get(i);
                if (map2.get("Catalog") != null) {
                    this.results.add(new XmlParserCatalogResult((Map)map2.get("Catalog")));
                    continue;
                }
                if (map2.get("Offer") == null) continue;
                this.results.add(new XmlParserOfferResult((Map)map2.get("Offer")));
            }
        } else {
            this.results = new ArrayList(0);
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public String getSpellSuggestions() {
        return XmlParser.getString(this.root, "/ResultSet/spellSuggestions");
    }

    public List listResults() {
        return this.results;
    }

    private class XmlParserOfferResult
    implements Offer {
        private Map offer;

        public XmlParserOfferResult(Map map) {
            this.offer = map;
        }

        public String getUrl() {
            return null;
        }

        public String getProductName() {
            return null;
        }

        public Thumbnail getThumbnail() {
            return null;
        }

        public String getSummary() {
            return null;
        }

        public Merchant getMerchant() {
            return null;
        }
    }

    private class XmlParserCatalogResult
    implements Catalog {
        private Map catalog;

        public XmlParserCatalogResult(Map map) {
            this.catalog = map;
        }

        public String getUrl() {
            return null;
        }

        public String getProductName() {
            return null;
        }

        public BigDecimal getPriceFrom() {
            return null;
        }

        public BigDecimal getPriceTo() {
            return null;
        }

        public Thumbnail getThumbnail() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getSummary() {
            return null;
        }

        public UserRating getUserRating() {
            return null;
        }

        public Specification[] listSpecifications() {
            return new Specification[0];
        }

        public BigInteger getId() {
            return null;
        }
    }
}

