/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.GraphWriter;
import visualizer.graph.Vertex;
import visualizer.graph.localAttribute;
import visualizer.triangulation.Triangulation;
import visualizer.web.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLGraphSaxDoc
extends DefaultHandler {
    private String tempVal;
    private String filename;
    private Context context = Context.INIT;
    private List<localAttribute> attribs = new ArrayList<localAttribute>();
    private Vector<Vertex> vertex = new Vector();
    private Vertex tempVertex;
    private Graph graph;
    private Triangulation triang;
    private Vector<Edge> edges;
    private Hashtable<Long, Vertex> vertexIndex;

    public void run(String filename, Graph graph) throws IOException {
        this.graph = graph;
        this.parseDocument(filename);
    }

    private void parseDocument(String filename) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            InputSource in = new InputSource(new InputStreamReader((InputStream)new FileInputStream(filename), "ISO-8859-1"));
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (this.context == Context.SCALARS && qName.equalsIgnoreCase("scalar")) {
            int index = this.graph.addScalarName(attributes.getValue("name"));
            this.tempVertex.setScalar(index, Float.parseFloat(attributes.getValue("value")));
        } else if (qName.equalsIgnoreCase("scalars")) {
            this.context = Context.SCALARS;
        } else if (qName.equalsIgnoreCase("vertex")) {
            this.context = Context.VERTEX;
            this.tempVertex = new Vertex(WebElement.getStubElement(), Long.parseLong(attributes.getValue("id")));
        } else if (qName.equalsIgnoreCase("graph")) {
            this.attribs.add(new localAttribute(attributes.getQName(0), attributes.getValue(0)));
        } else if (qName.equalsIgnoreCase("edges")) {
            this.vertexIndex = new Hashtable();
            for (Vertex v : this.vertex) {
                this.vertexIndex.put(v.getId(), v);
            }
            this.context = Context.EDGES;
            this.triang = new Triangulation(attributes.getValue("name"));
            this.edges = new Vector();
        } else if (qName.equalsIgnoreCase("edge")) {
            long vertex1 = Long.parseLong(attributes.getValue("source"));
            long vertex2 = Long.parseLong(attributes.getValue("target"));
            Vertex v1 = this.vertexIndex.get(vertex1);
            Vertex v2 = this.vertexIndex.get(vertex2);
            this.edges.add(new Edge(v1, v2));
        } else if (this.context == Context.VERTEX) {
            if (qName.equalsIgnoreCase("x-coordinate")) {
                this.tempVertex.setX(Float.parseFloat(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("y-coordinate")) {
                this.tempVertex.setY(Float.parseFloat(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("title")) {
                this.tempVertex.getWebElement().setTitle(GraphWriter.unConvert(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("url")) {
                this.tempVertex.getWebElement().setUrl(GraphWriter.unConvert(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("snippet")) {
                this.tempVertex.getWebElement().setSnippet(GraphWriter.unConvert(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("scalar-class")) {
                this.tempVertex.getWebElement().setScalar(Float.parseFloat(attributes.getValue(0)));
            } else if (qName.equalsIgnoreCase("date")) {
                this.tempVertex.getWebElement().setDate(GraphWriter.unConvert(attributes.getValue(0)));
            }
        } else if (this.context == Context.INIT) {
            this.attribs.add(new localAttribute(qName, attributes.getValue(0)));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = this.tempVal + new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("vertex")) {
            this.vertex.add(this.tempVertex);
        } else if (qName.equalsIgnoreCase("edges")) {
            this.edges = XMLGraphSaxDoc.compress(this.edges);
            this.triang.setEdges(this.edges);
            this.graph.addTriangulation(this.triang);
        }
    }

    public String getAttribute(String description) {
        for (localAttribute a : this.attribs) {
            if (!description.equalsIgnoreCase(a.name)) continue;
            return a.value;
        }
        return null;
    }

    public Vector<Vertex> getVertex() {
        return this.vertex;
    }

    public static Vector<Edge> compress(Vector<Edge> edges) {
        if (edges.size() > 0) {
            Collections.sort(edges);
            Vector<Edge> edges_aux = edges;
            edges = new Vector();
            int n = 0;
            edges.add(edges_aux.elementAt(0));
            for (int i = 1; i < edges_aux.size(); ++i) {
                if (edges_aux.elementAt(n).equals(edges_aux.elementAt(i))) continue;
                edges.add(edges_aux.elementAt(i));
                n = i;
            }
        }
        return edges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        INIT,
        VERTEX,
        SCALARS,
        EDGES;

    }
}

