/*
 * Decompiled with CFR 0.152.
 */
package visualizer.preprocessing.stopwords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StopwordsList {
    protected List<String> stopwords;
    protected String stopwordListname;

    protected StopwordsList() {
    }

    public StopwordsList(String stopwordListname) {
        this.stopwordListname = stopwordListname;
        this.stopwords = new ArrayList<String>();
        this.fillList();
        ArrayList<String> stopwords_aux = new ArrayList<String>();
        for (String stp : this.stopwords) {
            if (stopwords_aux.contains(stp.toLowerCase())) continue;
            stopwords_aux.add(stp.toLowerCase());
        }
        Collections.sort(stopwords_aux);
        this.stopwords = stopwords_aux;
    }

    protected abstract void fillList();

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public void addStopwords(List<String> stopwords) {
        for (String stopword : stopwords) {
            if (this.stopwords.contains(stopword.toLowerCase())) continue;
            this.stopwords.add(stopword.toLowerCase());
        }
        Collections.sort(this.stopwords);
    }

    public void removeStopword(String stopword) {
        this.stopwords.remove(stopword);
    }

    public boolean isStopWord(String word) {
        return Collections.binarySearch(this.stopwords, word) >= 0;
    }

    public String toString() {
        return this.stopwordListname;
    }

    public String getStopwordListName() {
        return this.stopwordListname;
    }
}

