/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.io.IOException;
import visualizer.projection.distance.DistanceMeasure;

public class Euclidean
implements DistanceMeasure {
    public float calculateDistance(float[] pointA, float[] pointB) throws IOException {
        if (pointA.length == pointB.length) {
            float sum = 0.0f;
            float sub = 0.0f;
            for (int i = 0; i < pointA.length; ++i) {
                sub = pointA[i] - pointB[i];
                sum += sub * sub;
            }
            return (float)Math.sqrt(sum);
        }
        throw new IOException("Diferente dimensions during the distance calculation!");
    }

    public static float calculateNorm(float[] point) {
        float result = 0.0f;
        for (int i = 0; i < point.length; ++i) {
            result += point[i] * point[i];
        }
        return (float)Math.sqrt(result);
    }

    public static float calculateInnerProduct(float[] pointA, float[] pointB) throws IOException {
        if (pointA.length == pointB.length) {
            float result = 0.0f;
            for (int i = 0; i < pointA.length; ++i) {
                result += pointA[i] * pointB[i];
            }
            return result;
        }
        throw new IOException("Diferente dimensions during the inner product calculation!");
    }
}

