/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateXMLFromCorpus {
    public static void main(String[] args) {
        try {
            CreateXMLFromCorpus c = new CreateXMLFromCorpus();
            c.create("C:\\Documents and Settings\\Paulovich.LEONARDO\\Meus documentos\\Fernando\\join.zip", "C:\\Documents and Settings\\Paulovich.LEONARDO\\Meus documentos\\Fernando\\join.xml");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void create(String corpus, String xml) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(xml));
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
            out.write("<graph description=\"Treparel Patents\">\n");
            out.write("<number-iterations value=\"100\"/>\n");
            out.write("<fraction-delta value=\"8.0\"/>\n");
            out.write("<min-cut value=\"0.01\"/>\n");
            out.write("<max-cut value=\"0.75\"/>\n");
            out.write("<number-grams value=\"1\"/>\n");
            out.write("<number-connections value=\"10\"/>\n");
            out.write("<number-neighbors value=\"2\"/>\n");
            out.write("<reducing value=\"false\"/>\n");
            out.write("<dimensions value=\"20\"/>\n");
            out.write("<stp-list value=\"English\"/>\n");
            out.write("<!--   vertex   -->\n");
            this.processCorpus(out, corpus);
            out.write("<!--   edges   -->\n");
            out.write("<edges name=\"None\">\n");
            out.write("</edges>\n");
            out.write("</graph>\n");
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + corpus + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + corpus + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void processCorpus(BufferedWriter out, String corpus) throws IOException {
        Vector<String> itemUrls = this.createFilenames(corpus);
        Vector<String> titles = this.createTitles(corpus, 1, itemUrls);
        Vector<String> pClass = new Vector<String>();
        for (int i = 0; i < itemUrls.size(); ++i) {
            out.write("<vertex id=\"");
            out.write(Integer.toString(i));
            out.write("\">\n");
            out.write("<x-coordinate value=\"");
            out.write(Double.toString(Math.random()));
            out.write("\"/>\n");
            out.write("<y-coordinate value=\"");
            out.write(Double.toString(Math.random()));
            out.write("\"/>\n");
            out.write("<title value=\"");
            out.write(titles.get(i));
            out.write("\"/>\n");
            out.write("<snippet value=\"");
            out.write(this.getFullContent(corpus, itemUrls.get(i)));
            out.write("\"/>\n");
            out.write("<url value=\"");
            out.write("");
            out.write("\"/>\n");
            String ini = itemUrls.get(i).substring(0, 2);
            if (!pClass.contains(ini)) {
                pClass.add(ini);
                System.out.println(ini);
            }
            float scalar = pClass.indexOf(ini);
            out.write("<scalar-class value=\"");
            out.write(Float.toString(scalar));
            out.write("\"/>\n");
            out.write("<date value=\"");
            out.write("");
            out.write("\"/>\n");
            out.write("<scalars>\n");
            out.write("<scalar name=\"...\" value=\"0.0\"/>\n");
            out.write("<scalar name=\"patent class\" value=\"");
            out.write(Float.toString(scalar));
            out.write("\"/>\n");
            out.write("</scalars>\n");
            out.write("</vertex>\n");
        }
    }

    private String getFullContent(String corpus, String itemUrl) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(corpus);
            ZipEntry entry = zip.getEntry(itemUrl);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                StringBuffer text = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    text.append(line + "\n");
                }
                String string = text.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new IOException("File " + itemUrl + " does not exist.");
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> createTitles(String corpus, int nrLines, Vector<String> itemUrls) {
        Vector<String> titles = new Vector<String>();
        ZipFile zip = null;
        try {
            zip = new ZipFile(corpus);
            for (String filename : itemUrls) {
                if (nrLines <= 0) continue;
                ZipEntry entry = zip.getEntry(filename);
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                if (entry == null) continue;
                String line = "";
                String line_aux = null;
                int i = 0;
                while ((line_aux = in.readLine()) != null && i < nrLines) {
                    line_aux = line_aux.replace("&", "");
                    line_aux = line_aux.replace("\"", "");
                    line_aux = line_aux.replace("<b>", "");
                    if ((line_aux = line_aux.replace("</b>", "")).trim().length() <= 1) continue;
                    line = line + " " + line_aux;
                    ++i;
                }
                titles.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return titles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> createFilenames(String corpus) {
        Vector<String> itemUrls = new Vector<String>();
        ZipFile zip = null;
        try {
            Vector<String> filenames_aux = new Vector<String>();
            zip = new ZipFile(corpus);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry2;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                filenames_aux.add(entry2.getName());
            }
            ArrayList<Integer> index_aux = new ArrayList<Integer>();
            for (int i = 0; i < filenames_aux.size(); ++i) {
                index_aux.add(i);
            }
            int[] index = new int[filenames_aux.size()];
            int i = 0;
            for (int j = 0; j < index.length; ++j) {
                int ind = (int)Math.pow(2.0, i);
                if (ind >= index_aux.size()) {
                    ind = 0;
                }
                index[j] = (Integer)index_aux.get(ind);
                index_aux.remove(ind);
                ++i;
            }
            for (i = 0; i < filenames_aux.size(); ++i) {
                itemUrls.add((String)filenames_aux.elementAt(index[i]));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return itemUrls;
    }
}

