/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.util.Vector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.triangulation.Neighborhood;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KNN {
    private int nrNeighbors = 5;

    public KNN(int nrNeighbors) {
        this.nrNeighbors = nrNeighbors;
    }

    public Vector<Neighborhood> execute(DistanceMatrix dmat) {
        Vector<Neighborhood> neighborhood = new Vector<Neighborhood>();
        if (this.nrNeighbors < dmat.getNumberPoints() - 1) {
            int i;
            Vector idsList = new Vector();
            Vector distanceList = new Vector();
            for (i = 0; i < dmat.getNumberPoints(); ++i) {
                Vector<Integer> ids = new Vector<Integer>();
                Vector<Float> distances = new Vector<Float>();
                for (int j = 0; j < this.nrNeighbors; ++j) {
                    ids.add(0);
                    distances.add(Float.valueOf(dmat.getMaxDistance()));
                }
                idsList.add(ids);
                distanceList.add(distances);
            }
            for (int j = 0; j < dmat.getNumberPoints(); ++j) {
                for (int k = 0; k < dmat.getNumberPoints(); ++k) {
                    if (j == k) continue;
                    this.addDistance((Vector)distanceList.elementAt(j), (Vector)idsList.elementAt(j), k, dmat.getDistance(j, k));
                }
            }
            for (i = 0; i < idsList.size(); ++i) {
                Neighborhood neigh = new Neighborhood(i);
                neighborhood.add(neigh);
                for (int j = 0; j < ((Vector)idsList.get(i)).size(); ++j) {
                    neigh.addNeighbor(new Neighborhood.Neighbor(((Integer)((Vector)idsList.get(i)).get(j)).intValue(), ((Float)((Vector)distanceList.get(i)).get(j)).floatValue()));
                }
            }
        } else {
            for (int i = 0; i < dmat.getNumberPoints(); ++i) {
                Neighborhood neigh = new Neighborhood(i);
                neighborhood.add(neigh);
                for (int j = 0; j < dmat.getNumberPoints(); ++j) {
                    if (i == j) continue;
                    neigh.addNeighbor(new Neighborhood.Neighbor(j, dmat.getDistance(i, j)));
                }
            }
        }
        return neighborhood;
    }

    private boolean addDistance(Vector<Float> distancesList, Vector<Integer> idsList, int id, float value) {
        if (distancesList.elementAt(0).floatValue() > value) {
            int i;
            for (i = 0; i < distancesList.size() && distancesList.elementAt(i).floatValue() > value; ++i) {
                if (i >= distancesList.size() - 1) continue;
                distancesList.setElementAt(distancesList.elementAt(i + 1), i);
                idsList.setElementAt(idsList.elementAt(i + 1), i);
            }
            distancesList.setElementAt(Float.valueOf(value), i - 1);
            idsList.setElementAt(id, i - 1);
            return true;
        }
        return false;
    }
}

