/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointsWriter {
    private String filename;

    public PointsWriter(String filename) {
        this.filename = filename;
    }

    public void save(float[][] points, float[] cdata, Vector<String> attributes) throws IOException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(this.filename));
            out.write("#Number objects: ");
            out.write(Integer.toString(points.length));
            out.write("\n");
            out.write("#Number dimensions: ");
            out.write(Integer.toString(points[0].length));
            out.write("\n");
            for (i = 0; i < attributes.size() - 1; ++i) {
                out.write(attributes.get(i).replaceAll("<>", " ").trim());
                out.write(";");
            }
            out.write(attributes.lastElement().replaceAll("<>", " ").trim());
            out.write("\n");
            for (i = 0; i < points.length; ++i) {
                for (int j = 0; j < points[i].length; ++j) {
                    out.write(Float.toString(points[i][j]));
                    out.write(";");
                }
                if (cdata != null) {
                    out.write(Float.toString(cdata[i]));
                } else {
                    out.write("0.0");
                }
                out.write("\n");
            }
        }
        catch (IOException e) {
            throw new IOException("Problems written \"" + this.filename + "\"!");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

