/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.GraphWriter;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.triangulation.Triangulation;
import visualizer.view.BrowserControl;
import visualizer.view.GraphBuilderDialog;
import visualizer.view.KMXClientView;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.SteppedComboBox;
import visualizer.view.StopwordsManager;
import visualizer.view.TrainningDocumentsSelection;
import visualizer.view.color.ColorScalePanel;
import visualizer.view.color.ColorTable;
import visualizer.view.label.CovarianceLabel;
import visualizer.view.label.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel
extends JPanel {
    private String title = "";
    private int id;
    private static int count = 0;
    private Graph graph;
    private ProjectionExplorerWeb parent;
    private boolean isVertexLabelVisible = true;
    private boolean highlightLabel = false;
    private BufferedImage imageBuffer;
    private Font font = new Font("Verdana", 1, 12);
    private static SelectionType type = SelectionType.CREATE_LABEL;
    private Vector<Label> labels = new Vector();
    private Vertex markedVertex;
    private ColorTable colorTable;
    private ColorScalePanel csp;
    private StopwordsManager stpManager;
    private TrainningDocumentsSelection trainDocsSelection;
    private DefaultComboBoxModel colorComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel sizeComboModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel edgesComboModel = new DefaultComboBoxModel();
    private JComboBox colorCombo;
    private JLabel coloredLabel;
    private JPanel commandsPanel;
    private JComboBox edgesCombo;
    private JButton goToolbarButton;
    private JPanel interactionPanel;
    private JButton kmxButton;
    private JLabel numberDocumentsLabel;
    private JTextField numberDocumentsTextField;
    private JButton reprojectButton;
    private JLabel searchToolbarLabel;
    private JTextField searchToolbarTextField;
    private JComboBox sizeCombo;
    private JButton stopwordsButton;
    private JLabel triangulationLabel;
    private JLabel vertexRayLabel;
    private JPanel viewPanel;
    private JScrollPane viewScrollPane;
    private JSplitPane viewSplitPane;

    public GraphPanel(ProjectionExplorerWeb parent, StopwordListManager stpListManager, String title) {
        this.parent = parent;
        this.title = title;
        this.id = ++count;
        this.initComponents();
        this.stpManager = new StopwordsManager((Frame)parent, stpListManager);
        ((SteppedComboBox)this.edgesCombo).setPopupWidth(100);
        this.setTrainDocsSelection(null);
    }

    private void initComponents() {
        this.commandsPanel = new JPanel();
        this.reprojectButton = new JButton();
        this.interactionPanel = new JPanel();
        this.goToolbarButton = new JButton();
        this.coloredLabel = new JLabel();
        this.searchToolbarLabel = new JLabel();
        this.searchToolbarTextField = new JTextField();
        this.edgesCombo = new SteppedComboBox((ComboBoxModel)this.edgesComboModel);
        this.triangulationLabel = new JLabel();
        this.sizeCombo = new SteppedComboBox((ComboBoxModel)this.sizeComboModel);
        this.vertexRayLabel = new JLabel();
        this.colorCombo = new SteppedComboBox((ComboBoxModel)this.colorComboModel);
        this.numberDocumentsLabel = new JLabel();
        this.numberDocumentsTextField = new JTextField();
        this.stopwordsButton = new JButton();
        this.kmxButton = new JButton();
        this.viewSplitPane = new JSplitPane();
        this.viewScrollPane = new JScrollPane();
        this.viewPanel = new ViewPanel();
        this.setLayout(new BorderLayout());
        this.commandsPanel.setLayout(new GridBagLayout());
        this.commandsPanel.setBorder(BorderFactory.createTitledBorder("Commands"));
        this.reprojectButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Play16.gif")));
        this.reprojectButton.setText("Reproject");
        this.reprojectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.reprojectButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.reprojectButton, gridBagConstraints);
        this.interactionPanel.setLayout(new GridBagLayout());
        this.interactionPanel.setBorder(BorderFactory.createEtchedBorder());
        this.goToolbarButton.setText("Go");
        this.goToolbarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.goToolbarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.interactionPanel.add((Component)this.goToolbarButton, gridBagConstraints);
        this.coloredLabel.setText("       Color  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.coloredLabel, gridBagConstraints);
        this.searchToolbarLabel.setText("Search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.interactionPanel.add((Component)this.searchToolbarLabel, gridBagConstraints);
        this.searchToolbarTextField.setColumns(25);
        this.searchToolbarTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                GraphPanel.this.searchToolbarTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.interactionPanel.add((Component)this.searchToolbarTextField, gridBagConstraints);
        this.edgesCombo.setMaximumSize(new Dimension(150, 27));
        this.edgesCombo.setMinimumSize(new Dimension(100, 27));
        this.edgesCombo.setPreferredSize(new Dimension(100, 27));
        this.edgesCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.edgesComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.edgesCombo, gridBagConstraints);
        this.triangulationLabel.setText("   Edges ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.triangulationLabel, gridBagConstraints);
        this.sizeCombo.setMaximumSize(new Dimension(150, 27));
        this.sizeCombo.setMinimumSize(new Dimension(100, 27));
        this.sizeCombo.setPreferredSize(new Dimension(100, 27));
        this.sizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.sizeComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.sizeCombo, gridBagConstraints);
        this.vertexRayLabel.setText("    Size  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.vertexRayLabel, gridBagConstraints);
        this.colorCombo.setMaximumSize(new Dimension(150, 27));
        this.colorCombo.setMinimumSize(new Dimension(100, 27));
        this.colorCombo.setOpaque(false);
        this.colorCombo.setPreferredSize(new Dimension(100, 27));
        this.colorCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.colorComboActionPerformed(evt);
            }
        });
        this.colorCombo.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GraphPanel.this.colorComboMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.interactionPanel.add((Component)this.colorCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.interactionPanel, gridBagConstraints);
        this.numberDocumentsLabel.setText("Documents");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.numberDocumentsLabel, gridBagConstraints);
        this.numberDocumentsTextField.setColumns(4);
        this.numberDocumentsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.numberDocumentsTextField, gridBagConstraints);
        this.stopwordsButton.setText("STP");
        this.stopwordsButton.setToolTipText("Manage Stopwords");
        this.stopwordsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.stopwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.stopwordsButton, gridBagConstraints);
        this.kmxButton.setText("KMX");
        this.kmxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanel.this.kmxButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.commandsPanel.add((Component)this.kmxButton, gridBagConstraints);
        this.add((Component)this.commandsPanel, "North");
        this.viewSplitPane.setOrientation(0);
        this.viewSplitPane.setOneTouchExpandable(true);
        this.viewPanel.setBorder(BorderFactory.createEtchedBorder());
        this.viewScrollPane.setViewportView(this.viewPanel);
        this.viewSplitPane.setRightComponent(this.viewScrollPane);
        this.add((Component)this.viewSplitPane, "Center");
    }

    private void kmxButtonActionPerformed(ActionEvent evt) {
        KMXClientView kmxw = new KMXClientView(this, this.parent);
        kmxw.setLocationRelativeTo(this.parent);
        kmxw.setVisible(true);
    }

    private void stopwordsButtonActionPerformed(ActionEvent evt) {
        this.stpManager.show(this.parent);
    }

    private void reprojectButtonActionPerformed(ActionEvent evt) {
        Graph newGraph = new Graph();
        newGraph.setVertex(this.graph.getVertex());
        GraphBuilderDialog md = new GraphBuilderDialog(this.parent);
        int result = md.show(newGraph, this.stpManager.getStopwordListManager());
        if (result == 0) {
            this.setGraph(newGraph);
            this.parent.refreshPointsList();
            this.cleanLabels();
            this.cleanMarkedPoints();
        }
    }

    private void colorComboMouseClicked(MouseEvent evt) {
        String selectedScalar;
        if (evt.getClickCount() == 2 && !(selectedScalar = (String)this.colorCombo.getSelectedItem()).equals("...")) {
            int index = this.graph.removeScalarName(selectedScalar);
            for (Vertex v : this.graph.getVertex()) {
                v.removeScalar(index);
            }
            this.sizeComboModel.removeElement(selectedScalar);
            this.colorComboModel.removeElement(selectedScalar);
            this.colorCombo.setSelectedIndex(0);
            this.sizeCombo.setSelectedIndex(0);
        }
    }

    private void goToolbarButtonActionPerformed(ActionEvent evt) {
        if (this.graph != null) {
            try {
                this.graph.createCdata(this.searchToolbarTextField.getText());
                this.refreshScalars("'" + this.searchToolbarTextField.getText() + "'");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void searchToolbarTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.goToolbarButtonActionPerformed(null);
        }
    }

    private void edgesComboActionPerformed(ActionEvent evt) {
        this.cleanImage();
        this.repaint();
    }

    private void sizeComboActionPerformed(ActionEvent evt) {
        String scalar = (String)((JComboBox)evt.getSource()).getSelectedItem();
        if (scalar != null) {
            ((ViewPanel)this.viewPanel).resizeVertexAs(scalar);
        }
    }

    private void colorComboActionPerformed(ActionEvent evt) {
        String scalar = (String)((JComboBox)evt.getSource()).getSelectedItem();
        if (scalar != null) {
            ((ViewPanel)this.viewPanel).colorAs(scalar);
        }
    }

    public SelectionType getType() {
        return type;
    }

    public void setType(SelectionType type) {
        GraphPanel.type = type;
    }

    public boolean isIsVertexLabelVisible() {
        return this.isVertexLabelVisible;
    }

    public void setIsVertexLabelVisible(boolean isVertexLabelVisible) {
        this.isVertexLabelVisible = isVertexLabelVisible;
    }

    public void cleanImage() {
        this.imageBuffer = null;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        if (this.graph != null) {
            for (Vertex v : graph.getVertex()) {
                v.setColorTable(this.colorTable);
            }
            this.refreshScalars(null);
            this.edgesComboModel.removeAllElements();
            for (String name : this.graph.getTriangulationsNames()) {
                this.edgesComboModel.addElement(name);
            }
            this.numberDocumentsTextField.setText(Integer.toString(this.graph.getVertex().size()));
            this.viewPanel.setPreferredSize(new Dimension((int)((double)this.graph.getSize().width * 1.5), (int)((double)this.graph.getSize().height * 1.5)));
            this.viewPanel.setSize(new Dimension((int)((double)this.graph.getSize().width * 1.5), (int)((double)this.graph.getSize().height * 1.5)));
            this.cleanImage();
            this.repaint();
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.repaint();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Vector<Label> getLabels() {
        return this.labels;
    }

    public boolean isHighlightLabel() {
        return this.highlightLabel;
    }

    public void setHighlightLabel(boolean highlightLabel) {
        this.highlightLabel = highlightLabel;
    }

    public void zoom(float rate) {
        if (this.graph != null) {
            Vector<Vertex> vertex = this.graph.getVertex();
            float maxX = vertex.elementAt(0).getX();
            float minX = vertex.elementAt(0).getX();
            float maxY = vertex.elementAt(0).getY();
            float minY = vertex.elementAt(0).getY();
            for (Vertex v : vertex) {
                if (maxX < v.getX()) {
                    maxX = v.getX();
                } else if (minX > v.getX()) {
                    minX = v.getX();
                }
                if (maxY < v.getY()) {
                    maxY = v.getY();
                    continue;
                }
                if (!(minY > v.getY())) continue;
                minY = v.getY();
            }
            float endX = maxX * rate;
            float endY = maxY * rate;
            for (Vertex v : vertex) {
                if (maxX != minX) {
                    v.setX((v.getX() - minX) / (maxX - minX) * (endX - minX) + minX);
                } else {
                    v.setX(minX);
                }
                if (maxY != minY) {
                    v.setY((v.getY() - minY) / (maxY - minY) * (endY - minY) + minY);
                    continue;
                }
                v.setY(minY);
            }
            this.viewPanel.setPreferredSize(new Dimension((int)((double)this.graph.getSize().width * 1.5), (int)((double)this.graph.getSize().height * 1.5)));
            this.viewPanel.setSize(new Dimension((int)((double)this.graph.getSize().width * 1.5), (int)((double)this.graph.getSize().height * 1.5)));
            for (Label label : this.labels) {
                label.getRectangle().x = (int)((float)label.getRectangle().x * rate);
                label.getRectangle().y = (int)((float)label.getRectangle().y * rate);
                label.getRectangle().height = (int)((float)label.getRectangle().height * rate);
                label.getRectangle().width = (int)((float)label.getRectangle().width * rate);
            }
            this.cleanImage();
        }
    }

    public void cleanLabels() {
        this.labels.clear();
    }

    public void cleanMarkedPoints() {
        if (this.graph != null) {
            this.markedVertex = null;
            for (Vertex vertex : this.graph.getVertex()) {
                if (!vertex.isSelected()) continue;
                String scalarName = this.colorCombo.getSelectedItem().toString();
                if (scalarName.equals("...")) {
                    vertex.setColor(Color.LIGHT_GRAY);
                } else {
                    vertex.setColor(this.graph.getScalarIndex(scalarName));
                }
                vertex.setSelected(false);
            }
            Triangulation tri = this.graph.getTriangulation((String)this.edgesCombo.getSelectedItem());
            for (Edge e : tri.getEdges()) {
                e.setSelected(false);
            }
        }
        this.cleanImage();
        this.repaint();
    }

    public void markNeighbors(Vertex vertex) {
        if (this.graph != null) {
            if (this.trainDocsSelection != null) {
                this.trainDocsSelection.addVertex(vertex);
            }
            this.cleanMarkedPoints();
            Vector<Vertex> neighborsVertex = new Vector<Vertex>();
            Vector<Edge> neighborsEdges = new Vector<Edge>();
            String triangname = (String)this.edgesCombo.getSelectedItem();
            this.graph.getNeighbors(neighborsVertex, neighborsEdges, triangname, vertex, 1);
            this.parent.setNearestNeighborsPoints(vertex, neighborsVertex);
            vertex.setSelected(true);
            if (neighborsVertex != null) {
                for (Vertex v : neighborsVertex) {
                    v.setSelected(true);
                }
            }
            if (neighborsEdges != null) {
                for (Edge e : neighborsEdges) {
                    e.setSelected(true);
                }
            }
            this.cleanImage();
            this.repaint();
        }
    }

    public void refreshScalars(String selScalar) {
        this.colorComboModel.removeAllElements();
        this.sizeComboModel.removeAllElements();
        for (String name : this.graph.getScalarNames()) {
            this.colorComboModel.addElement(name);
            this.sizeComboModel.addElement(name);
        }
        JComboBox aux = new JComboBox(this.colorComboModel);
        Dimension d = aux.getPreferredSize();
        ((SteppedComboBox)this.colorCombo).setPopupWidth(d.width);
        ((SteppedComboBox)this.sizeCombo).setPopupWidth(d.width);
        if (selScalar != null) {
            this.colorCombo.setSelectedItem(selScalar);
        }
    }

    public String getScalarName() {
        return (String)this.colorCombo.getSelectedItem();
    }

    public String getTriangulationName() {
        return (String)this.edgesCombo.getSelectedItem();
    }

    public ViewPanel getViewPanel() {
        return (ViewPanel)this.viewPanel;
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public StopwordsManager getStopwordsManager() {
        return this.stpManager;
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public ProjectionExplorerWeb getProjectionExplorerWeb() {
        return this.parent;
    }

    public TrainningDocumentsSelection getTrainDocsSelection() {
        return this.trainDocsSelection;
    }

    public void setTrainDocsSelection(TrainningDocumentsSelection trainDocsSelection) {
        this.trainDocsSelection = trainDocsSelection;
        if (this.trainDocsSelection == null) {
            this.viewSplitPane.setEnabled(false);
            this.viewSplitPane.setDividerLocation(0.0);
            this.viewSplitPane.setDividerSize(0);
        } else {
            this.viewSplitPane.setLeftComponent(this.trainDocsSelection);
            this.viewSplitPane.setEnabled(true);
            this.viewSplitPane.setDividerSize(10);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ViewPanel
    extends JPanel {
        private Polygon polygon;
        private Label selectedLabel = null;
        private Point source = null;
        private Point target = null;
        private Color color = Color.RED;
        private Vertex selectedVertex;
        private Vector<Vertex> selectedVertices;
        private String toolTipLabel1;
        private String toolTipLabel2;
        private Point toolTipPosition;

        public ViewPanel() {
            GraphPanel.this.colorTable = new ColorTable();
            GraphPanel.this.csp = new ColorScalePanel(GraphPanel.this.parent);
            GraphPanel.this.csp.setColorTable(GraphPanel.this.colorTable);
            GraphPanel.this.csp.setPreferredSize(new Dimension(200, 12));
            this.add(GraphPanel.this.csp);
            this.setBackground(Color.WHITE);
            this.addMouseMotionListener(new MouseMotionListener());
            this.addMouseListener(new MouseClickedListener());
            this.setLayout(new FlowLayout(0));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (GraphPanel.this.imageBuffer == null) {
                GraphPanel.this.imageBuffer = new BufferedImage(GraphPanel.this.getGraph().getSize().width, GraphPanel.this.getGraph().getSize().height, 1);
                Graphics2D g2Buffer = GraphPanel.this.imageBuffer.createGraphics();
                g2Buffer.setColor(this.getBackground());
                g2Buffer.fillRect(0, 0, GraphPanel.this.getGraph().getSize().width, GraphPanel.this.getGraph().getSize().height);
                g2Buffer.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2Buffer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2Buffer.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2Buffer.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2Buffer.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2Buffer.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                if (GraphPanel.this.graph != null) {
                    GraphPanel.this.graph.draw((String)GraphPanel.this.edgesCombo.getSelectedItem(), g2Buffer);
                }
            }
            g2.drawImage(GraphPanel.this.imageBuffer, 0, 0, GraphPanel.this.getGraph().getSize().width, GraphPanel.this.getGraph().getSize().height, null);
            for (Label l : GraphPanel.this.labels) {
                l.drawLabel(g, GraphPanel.this.font, false);
            }
            if (this.source != null && this.target != null) {
                int x = this.source.x;
                int width = this.target.x - this.source.x;
                int y = this.source.y;
                int height = this.target.y - this.source.y;
                if (this.source.x > this.target.x) {
                    x = this.target.x;
                    width = this.source.x - this.target.x;
                }
                if (this.source.y > this.target.y) {
                    y = this.target.y;
                    height = this.source.y - this.target.y;
                }
                g.setColor(this.color);
                g.drawRect(x, y, width, height);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.setPaint(this.color);
                g2.fill(new Rectangle(x, y, width, height));
            } else if (this.selectedLabel != null) {
                this.selectedLabel.drawLabel(g, GraphPanel.this.font, true);
            } else if (GraphPanel.this.isVertexLabelVisible && (this.toolTipLabel1 != null || this.toolTipLabel2 != null) && this.toolTipPosition != null) {
                g.setFont(GraphPanel.this.font);
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                int waux1 = metrics.stringWidth(this.toolTipLabel1);
                int waux2 = metrics.stringWidth(this.toolTipLabel2);
                int width = waux1 > waux2 ? waux1 : waux2;
                int height = metrics.getAscent();
                g2.setComposite(AlphaComposite.getInstance(3, 0.85f));
                g2.setPaint(Color.WHITE);
                g2.fill(new Rectangle(this.toolTipPosition.x - 2, this.toolTipPosition.y - height, width + 4, 2 * height + 4));
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g.setColor(Color.DARK_GRAY);
                g.drawRect(this.toolTipPosition.x - 2, this.toolTipPosition.y - height, width + 4, 2 * height + 4);
                g.setColor(Color.BLUE);
                g.drawString(this.toolTipLabel1, this.toolTipPosition.x, this.toolTipPosition.y);
                g.setColor(Color.GREEN.darker());
                g.drawString(this.toolTipLabel2, this.toolTipPosition.x, this.toolTipPosition.y + height);
            }
            if (this.polygon != null) {
                g.setColor(this.color);
                g.drawPolygon(this.polygon);
                g2.setComposite(AlphaComposite.getInstance(3, 0.45f));
                g2.setPaint(this.color);
                g2.fillPolygon(this.polygon);
            }
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (GraphPanel.this.csp != null) {
                GraphPanel.this.csp.setBackground(bg);
            }
        }

        public void colorAs(String scalarName) {
            Vector<Vertex> vertex = GraphPanel.this.graph.getVertex();
            for (Vertex v : vertex) {
                if (scalarName.equals("...")) {
                    v.setColor(Color.LIGHT_GRAY);
                    continue;
                }
                v.setColor(GraphPanel.this.graph.getScalarIndex(scalarName));
            }
            GraphPanel.this.cleanImage();
            this.repaint();
        }

        public void resizeVertexAs(String scalarName) {
            Vector<Vertex> vertex = GraphPanel.this.graph.getVertex();
            for (Vertex v : vertex) {
                v.setRayFactor(GraphPanel.this.graph.getScalarIndex(scalarName));
            }
            GraphPanel.this.cleanImage();
            this.repaint();
        }

        public Vector<Vertex> getSelectedVertex(Polygon polygon) {
            Vector<Vertex> selected = new Vector<Vertex>();
            if (GraphPanel.this.graph != null) {
                for (Vertex v : GraphPanel.this.graph.getVertex()) {
                    if (!polygon.contains(v.getX(), v.getY())) continue;
                    selected.add(v);
                }
            }
            return selected;
        }

        public Vector<Vertex> getSelectedVertex(Point localSource, Point localTarget) {
            Vector<Vertex> selectedVertex = new Vector<Vertex>();
            int x = localSource.x;
            int width = localTarget.x - localSource.x;
            int y = localSource.y;
            int height = localTarget.y - localSource.y;
            if (localSource.x > localTarget.x) {
                x = localTarget.x;
                width = localSource.x - localTarget.x;
            }
            if (localSource.y > localTarget.y) {
                y = localTarget.y;
                height = localSource.y - localTarget.y;
            }
            Rectangle rect = new Rectangle(x, y, width, height);
            for (Vertex v : GraphPanel.this.graph.getVertex()) {
                if (!v.isInside(rect)) continue;
                selectedVertex.add(v);
            }
            return selectedVertex;
        }

        public void adjustPanel() {
            float iniX = GraphPanel.this.graph.getVertex().get(0).getX();
            float iniY = GraphPanel.this.graph.getVertex().get(0).getY();
            float max_x = iniX;
            float max_y = iniX;
            float min_x = iniY;
            float min_y = iniY;
            int zero = Vertex.getRayBase() * 5 + 10;
            for (int i = 1; i < GraphPanel.this.graph.getVertex().size(); ++i) {
                float x = GraphPanel.this.graph.getVertex().get(i).getX();
                if (max_x < x) {
                    max_x = x;
                } else if (min_x > x) {
                    min_x = x;
                }
                float y = GraphPanel.this.graph.getVertex().get(i).getY();
                if (max_y < y) {
                    max_y = y;
                    continue;
                }
                if (!(min_y > y)) continue;
                min_y = y;
            }
            for (Vertex v : GraphPanel.this.graph.getVertex()) {
                v.setX(v.getX() + (float)zero - min_x);
                v.setY(v.getY() + (float)zero - min_y);
            }
            Dimension d = GraphPanel.this.getSize();
            d.width = (int)max_x + zero;
            d.height = (int)max_y + zero;
            GraphPanel.this.setSize(d);
            GraphPanel.this.setPreferredSize(d);
        }

        public void markVertices(Vector<Vertex> vertices, Color color) {
            if (vertices != null) {
                GraphPanel.this.cleanMarkedPoints();
                for (Vertex v : vertices) {
                    v.setSelected(true);
                }
                GraphPanel.this.cleanImage();
                this.repaint();
            }
        }

        public void markVertexToCoordinate(Color color, Vector<Vertex> other) {
            if (other != null) {
                GraphPanel.this.cleanMarkedPoints();
                for (Vertex v : other) {
                    for (Vertex w : GraphPanel.this.graph.getVertex()) {
                        if (!v.getWebElement().equals(w.getWebElement())) continue;
                        w.setSelected(true);
                    }
                }
                this.repaint();
            }
        }

        public Label getLabelByPosition(Point point) {
            float dist = Float.MAX_VALUE;
            Label label = null;
            for (Label l : GraphPanel.this.labels) {
                float aux = l.weightDistance(point);
                if (aux == -1.0f || !(dist > aux)) continue;
                dist = aux;
                label = l;
            }
            return label;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MouseClickedListener
        extends MouseAdapter {
            MouseClickedListener() {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                super.mouseClicked(evt);
                if (GraphPanel.this.graph != null) {
                    if (evt.getButton() == 1) {
                        Vertex v = GraphPanel.this.graph.getVerticeByPosition(evt.getX(), evt.getY());
                        if (v != null) {
                            if (evt.getClickCount() == 1) {
                                GraphPanel.this.markNeighbors(v);
                                GraphPanel.this.markedVertex = v;
                            } else if (GraphPanel.this.parent.getAppletParent() == null) {
                                BrowserControl.displayURL(v.getWebElement().getUrl());
                            } else {
                                try {
                                    URL url = new URL(v.getWebElement().getUrl());
                                    GraphPanel.this.parent.getAppletParent().getAppletContext().showDocument(url, "_blank");
                                }
                                catch (MalformedURLException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            GraphPanel.this.parent.getPointsList().setSelectedValue(v, true);
                        }
                    } else if (evt.getButton() == 3) {
                        GraphPanel.this.cleanMarkedPoints();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                super.mousePressed(evt);
                if (evt.getButton() == 1) {
                    if (GraphPanel.this.graph != null) {
                        Point p = evt.getPoint();
                        ViewPanel.this.selectedVertex = GraphPanel.this.graph.getVerticeByPosition(p.x, p.y);
                        if (ViewPanel.this.selectedVertex == null) {
                            if (type == SelectionType.FIND_SUBGRAPH) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.ORANGE;
                            } else if (type == SelectionType.CREATE_LABEL) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.YELLOW;
                            } else if (type == SelectionType.SPLIT_GRAPH) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.RED;
                            } else if (type == SelectionType.SELECT_GRAPH) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.BLUE;
                            } else if (type == SelectionType.VIEW_CONTENT) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.GREEN;
                            } else if (type == SelectionType.COORD_SELECT) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.CYAN;
                            } else if (type == SelectionType.CUT_GRAPH) {
                                ViewPanel.this.source = evt.getPoint();
                                ViewPanel.this.color = Color.RED;
                            }
                        }
                    }
                } else if (evt.getButton() == 3) {
                    ViewPanel.this.polygon = new Polygon();
                    ViewPanel.this.polygon.addPoint(evt.getX(), evt.getY());
                    if (type == SelectionType.FIND_SUBGRAPH) {
                        ViewPanel.this.color = Color.ORANGE;
                    } else if (type == SelectionType.CREATE_LABEL) {
                        ViewPanel.this.color = Color.YELLOW;
                    } else if (type == SelectionType.SPLIT_GRAPH) {
                        ViewPanel.this.color = Color.RED;
                    } else if (type == SelectionType.SELECT_GRAPH) {
                        ViewPanel.this.color = Color.BLUE;
                    } else if (type == SelectionType.VIEW_CONTENT) {
                        ViewPanel.this.color = Color.GREEN;
                    } else if (type == SelectionType.COORD_SELECT) {
                        ViewPanel.this.color = Color.CYAN;
                    } else if (type == SelectionType.CUT_GRAPH) {
                        ViewPanel.this.color = Color.RED;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                super.mouseReleased(evt);
                if (GraphPanel.this.graph != null && (ViewPanel.this.source != null && ViewPanel.this.target != null || ViewPanel.this.polygon != null)) {
                    Vector<Vertex> vertices = null;
                    vertices = ViewPanel.this.polygon != null ? ViewPanel.this.getSelectedVertex(ViewPanel.this.polygon) : ViewPanel.this.getSelectedVertex(ViewPanel.this.source, ViewPanel.this.target);
                    if (vertices != null) {
                        if (type == SelectionType.FIND_SUBGRAPH) {
                            this.findSubGraph(vertices);
                        } else if (type == SelectionType.CREATE_LABEL) {
                            this.createLabel(vertices);
                        } else if (type == SelectionType.SPLIT_GRAPH) {
                            this.splitGraph(vertices);
                        } else if (type == SelectionType.SELECT_GRAPH) {
                            this.selectGraph(vertices);
                        } else if (type == SelectionType.VIEW_CONTENT) {
                            this.viewContent(vertices);
                        } else if (type == SelectionType.COORD_SELECT) {
                            this.coordinateSelect(vertices);
                        } else if (type == SelectionType.CUT_GRAPH) {
                            this.deleteVertex(vertices);
                        }
                    }
                }
                ViewPanel.this.polygon = null;
                ViewPanel.this.selectedVertex = null;
                ViewPanel.this.source = null;
                ViewPanel.this.target = null;
                ViewPanel.this.repaint();
            }

            private void deleteVertex(Vector<Vertex> vertex) {
                if (vertex != null) {
                    GraphPanel.this.graph.removeVertex(vertex);
                    GraphPanel.this.parent.refreshPointsList();
                    GraphPanel.this.numberDocumentsTextField.setText(Integer.toString(GraphPanel.this.graph.getVertex().size()));
                    GraphPanel.this.cleanMarkedPoints();
                    GraphPanel.this.cleanImage();
                    GraphPanel.this.repaint();
                }
            }

            private void viewContent(Vector<Vertex> selectedVertices) {
                if (selectedVertices.size() > 0) {
                    ViewPanel.this.selectedVertices = null;
                    ViewPanel.this.markVertices(selectedVertices, Color.BLUE);
                    for (Vertex v : selectedVertices) {
                        BrowserControl.displayURL(v.getWebElement().getUrl());
                    }
                }
            }

            private void splitGraph(Vector<Vertex> selectedVertices) {
            }

            private void createLabel(Vector<Vertex> selectedVertices) {
                if (selectedVertices.size() > 0) {
                    StopwordsList stp = GraphPanel.this.stpManager.getStopwordListManager().getStopwordListUsed();
                    CovarianceLabel label = new CovarianceLabel(selectedVertices, stp);
                    GraphPanel.this.labels.add(label);
                }
            }

            private void selectGraph(Vector<Vertex> selectedVertices) {
                if (ViewPanel.this.source != null && ViewPanel.this.target != null) {
                    ViewPanel.this.selectedVertices = selectedVertices;
                    ViewPanel.this.markVertices(selectedVertices, Color.BLUE);
                }
            }

            private void coordinateSelect(Vector<Vertex> selectedVertices) {
                if (ViewPanel.this.source != null && ViewPanel.this.target != null) {
                    ViewPanel.this.selectedVertices = selectedVertices;
                    ViewPanel.this.markVertices(selectedVertices, Color.CYAN);
                    for (GraphPanel p : GraphPanel.this.parent.getProjections()) {
                        ((ViewPanel)p.viewPanel).markVertexToCoordinate(Color.CYAN, ViewPanel.this.selectedVertices);
                    }
                    ViewPanel.this.selectedVertices = null;
                }
            }

            private void findSubGraph(Vector<Vertex> selectedVertices) {
                if (ViewPanel.this.source != null && ViewPanel.this.target != null) {
                    Vector subgraph = (Vector)selectedVertices.clone();
                    boolean stop = false;
                    while (!stop) {
                        stop = true;
                        for (Vertex v : selectedVertices) {
                            Vector<Vertex> neighborsVertex = new Vector<Vertex>();
                            Vector<Edge> neighborsEdges = new Vector<Edge>();
                            String triangname = (String)GraphPanel.this.edgesCombo.getSelectedItem();
                            GraphPanel.this.graph.getNeighbors(neighborsVertex, neighborsEdges, triangname, v, 1);
                            for (Vertex v2 : neighborsVertex) {
                                if (subgraph.contains(v2)) continue;
                                subgraph.remove(v);
                                stop = false;
                            }
                        }
                        selectedVertices = (Vector)subgraph.clone();
                    }
                    ViewPanel.this.selectedVertices = selectedVertices;
                    ViewPanel.this.markVertices(selectedVertices, Color.BLUE);
                }
            }
        }

        class MouseMotionListener
        extends MouseMotionAdapter {
            MouseMotionListener() {
            }

            public void mouseMoved(MouseEvent evt) {
                super.mouseMoved(evt);
                if (GraphPanel.this.graph != null) {
                    Vertex vertex = null;
                    if (GraphPanel.this.highlightLabel || evt.isControlDown()) {
                        ViewPanel.this.selectedLabel = ViewPanel.this.getLabelByPosition(evt.getPoint());
                    } else {
                        ViewPanel.this.selectedLabel = null;
                        vertex = GraphPanel.this.graph.getVerticeByPosition(evt.getX(), evt.getY());
                    }
                    if (vertex != null) {
                        ViewPanel.this.toolTipLabel1 = GraphWriter.unConvert(vertex.getWebElement().getTitle().replaceAll("<.*?>", " "));
                        ViewPanel.this.toolTipLabel2 = vertex.getWebElement().getUrl();
                        if (ViewPanel.this.toolTipLabel1.trim().length() > 0 || ViewPanel.this.toolTipLabel2.trim().length() > 0) {
                            if (ViewPanel.this.toolTipLabel1.length() > 60) {
                                ViewPanel.this.toolTipLabel1 = ViewPanel.this.toolTipLabel1.substring(0, 56) + "...";
                            }
                            if (ViewPanel.this.toolTipLabel2.length() > 60) {
                                ViewPanel.this.toolTipLabel2 = ViewPanel.this.toolTipLabel2.substring(0, 56) + "...";
                            }
                            ViewPanel.this.toolTipPosition = evt.getPoint();
                            ViewPanel.this.repaint();
                        }
                    } else {
                        ViewPanel.this.toolTipLabel1 = null;
                        ViewPanel.this.toolTipLabel2 = null;
                        ViewPanel.this.toolTipPosition = null;
                        ViewPanel.this.repaint();
                    }
                }
            }

            public void mouseDragged(MouseEvent evt) {
                if (ViewPanel.this.selectedVertex != null) {
                    if (ViewPanel.this.selectedVertices != null && ViewPanel.this.selectedVertices.size() > 0 && ViewPanel.this.selectedVertices.contains(ViewPanel.this.selectedVertex)) {
                        float x = (float)evt.getX() - ViewPanel.this.selectedVertex.getX();
                        float y = (float)evt.getY() - ViewPanel.this.selectedVertex.getY();
                        for (Vertex v : ViewPanel.this.selectedVertices) {
                            v.setX(x + v.getX());
                            v.setY(y + v.getY());
                        }
                        ViewPanel.this.adjustPanel();
                    } else {
                        ViewPanel.this.selectedVertex.setX(evt.getX());
                        ViewPanel.this.selectedVertex.setY(evt.getY());
                        ViewPanel.this.adjustPanel();
                    }
                    GraphPanel.this.cleanImage();
                } else if (ViewPanel.this.source != null) {
                    ViewPanel.this.target = evt.getPoint();
                }
                if (ViewPanel.this.polygon != null) {
                    ViewPanel.this.polygon.addPoint(evt.getX(), evt.getY());
                }
                GraphPanel.this.repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionType {
        FIND_SUBGRAPH,
        SPLIT_GRAPH,
        CREATE_LABEL,
        SELECT_GRAPH,
        VIEW_CONTENT,
        COORD_SELECT,
        CUT_GRAPH;

    }
}

