/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import visualizer.graph.Vertex;
import visualizer.view.GraphPanel;

public class TrainningDocumentsTableModel
extends AbstractTableModel {
    private String[] titles = new String[]{"Id", "Title", "Class Label"};
    private Vector<Vertex> content = new Vector();
    private Vector<String> classes = new Vector();
    private GraphPanel graphPanel;

    public TrainningDocumentsTableModel(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
        this.addTableModelListener(new MyTableModelListener());
    }

    public void addRow(Vertex vertex, String klass) {
        this.content.add(vertex);
        this.classes.add(klass);
        this.fireTableDataChanged();
    }

    public Vertex removeRow(int row) {
        Vertex v = this.content.get(row);
        this.content.remove(row);
        this.classes.remove(row);
        this.fireTableDataChanged();
        return v;
    }

    public Class getColumnClass(int c) {
        if (c == 0) {
            return Long.class;
        }
        if (c == 1) {
            return String.class;
        }
        if (c == 2) {
            return String.class;
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.content.size();
    }

    public String getColumnName(int col) {
        return this.titles[col];
    }

    public Object getValueAt(int row, int col) {
        if (this.content.size() > row) {
            Vertex v = this.content.get(row);
            if (col == 0) {
                return v.getId();
            }
            if (col == 1) {
                return v.getWebElement().getTitle();
            }
            if (col == 2) {
                return this.classes.get(row);
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            this.classes.set(row, (String)value);
        }
        this.fireTableDataChanged();
    }

    public Vertex getVertex(int row) {
        return this.content.get(row);
    }

    public class MyTableModelListener
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            ArrayList<String> classes_id = new ArrayList<String>();
            for (String klass : TrainningDocumentsTableModel.this.classes) {
                if (classes_id.contains(klass)) continue;
                classes_id.add(klass);
            }
            Collections.sort(classes_id);
            for (int i = 0; i < TrainningDocumentsTableModel.this.classes.size(); ++i) {
                float colorValue = classes_id.size() - (classes_id.indexOf(TrainningDocumentsTableModel.this.classes.get(i)) + 1);
                ((Vertex)TrainningDocumentsTableModel.this.content.get(i)).setTrDocsColor(TrainningDocumentsTableModel.this.graphPanel.getColorTable().getColor(colorValue /= (float)(classes_id.size() - 1)));
            }
            TrainningDocumentsTableModel.this.graphPanel.cleanImage();
            TrainningDocumentsTableModel.this.graphPanel.repaint();
        }
    }
}

