/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.color;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.color.ColorScale;
import visualizer.view.color.ColorScalePanel;
import visualizer.view.color.ColorTable;
import visualizer.view.color.GrayCS;
import visualizer.view.color.HeatedObjectCS;
import visualizer.view.color.LinGrayCS;
import visualizer.view.color.LocsCS;
import visualizer.view.color.RainbowCS;
import visualizer.view.color.UndefinedCD;

public class ColorScaleChange
extends JDialog {
    private ColorTable colorTable;
    private ProjectionExplorerWeb parent;
    private static ColorScaleChange instance;
    private ButtonGroup buttonGroup;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel coloScalePanel;
    private JPanel colorChosePanel;
    private JPanel colorPanel;
    private JRadioButton grayRadioButton;
    private JRadioButton heatedObjectsRadioButton;
    private JRadioButton linGrayRadioButton;
    private JRadioButton locsRadioButton;
    private JSlider maxSlider;
    private JSlider minSlider;
    private JRadioButton rainbowRadioButton;
    private JButton reverseButton;
    private JPanel scaleRangePanel;
    private JRadioButton undefinedRadioButton;

    private ColorScaleChange(ProjectionExplorerWeb parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
        ((ColorScalePanel)this.coloScalePanel).setColorTable(this.parent.getGraphPanel().getColorTable());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.colorPanel = new JPanel();
        this.scaleRangePanel = new JPanel();
        this.minSlider = new JSlider();
        this.maxSlider = new JSlider();
        this.coloScalePanel = new ColorScalePanel(this.parent);
        this.reverseButton = new JButton();
        this.colorChosePanel = new JPanel();
        this.undefinedRadioButton = new JRadioButton();
        this.grayRadioButton = new JRadioButton();
        this.heatedObjectsRadioButton = new JRadioButton();
        this.linGrayRadioButton = new JRadioButton();
        this.locsRadioButton = new JRadioButton();
        this.rainbowRadioButton = new JRadioButton();
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Change the Color Scale");
        this.setModal(true);
        this.colorPanel.setLayout(new BorderLayout(3, 3));
        this.colorPanel.setBorder(BorderFactory.createTitledBorder("Color Scale"));
        this.scaleRangePanel.setLayout(new GridBagLayout());
        this.scaleRangePanel.setBorder(BorderFactory.createTitledBorder("Scale Range"));
        this.minSlider.setMaximum(50);
        this.minSlider.setPaintLabels(true);
        this.minSlider.setPaintTicks(true);
        this.minSlider.setInverted(true);
        this.minSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ColorScaleChange.this.minSliderStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.minSlider, gridBagConstraints);
        this.maxSlider.setMaximum(50);
        this.maxSlider.setPaintLabels(true);
        this.maxSlider.setPaintTicks(true);
        this.maxSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ColorScaleChange.this.maxSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.scaleRangePanel.add((Component)this.maxSlider, gridBagConstraints);
        this.coloScalePanel.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.coloScalePanel, gridBagConstraints);
        this.reverseButton.setText("Reverse Scale");
        this.reverseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.reverseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.scaleRangePanel.add((Component)this.reverseButton, gridBagConstraints);
        this.colorPanel.add((Component)this.scaleRangePanel, "South");
        this.colorChosePanel.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.undefinedRadioButton);
        this.undefinedRadioButton.setSelected(true);
        this.undefinedRadioButton.setText("Undefined");
        this.undefinedRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.undefinedRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.undefinedRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.undefinedRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.undefinedRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.grayRadioButton);
        this.grayRadioButton.setText("Gray");
        this.grayRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.grayRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.grayRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.grayRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.grayRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.heatedObjectsRadioButton);
        this.heatedObjectsRadioButton.setText("Heated Objetcs");
        this.heatedObjectsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.heatedObjectsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.heatedObjectsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.heatedObjectsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.heatedObjectsRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.linGrayRadioButton);
        this.linGrayRadioButton.setText("Linear Gray");
        this.linGrayRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.linGrayRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.linGrayRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.linGrayRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.linGrayRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.locsRadioButton);
        this.locsRadioButton.setText("LOCS");
        this.locsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.locsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.locsRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.locsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.locsRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.rainbowRadioButton);
        this.rainbowRadioButton.setText("Rainbow");
        this.rainbowRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rainbowRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.rainbowRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.rainbowRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.colorChosePanel.add((Component)this.rainbowRadioButton, gridBagConstraints);
        this.colorPanel.add((Component)this.colorChosePanel, "Center");
        this.getContentPane().add((Component)this.colorPanel, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorScaleChange.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void maxSliderStateChanged(ChangeEvent evt) {
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        if (this.parent != null) {
            if (this.parent.getGraphPanel() != null) {
                this.parent.getGraphPanel().getViewPanel().colorAs(this.parent.getGraphPanel().getScalarName());
            }
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
        this.coloScalePanel.repaint();
    }

    private void minSliderStateChanged(ChangeEvent evt) {
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.parent != null) {
            if (this.parent.getGraphPanel() != null) {
                this.parent.getGraphPanel().getViewPanel().colorAs(this.parent.getGraphPanel().getScalarName());
            }
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
        this.coloScalePanel.repaint();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void reverseButtonActionPerformed(ActionEvent evt) {
        this.colorTable.getColorScale().setReverse(!this.colorTable.getColorScale().isReverse());
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.parent != null) {
            if (this.parent.getGraphPanel() != null) {
                this.parent.getGraphPanel().getViewPanel().colorAs(this.parent.getGraphPanel().getScalarName());
            }
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
        this.coloScalePanel.repaint();
    }

    private void rainbowRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new RainbowCS());
    }

    private void locsRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new LocsCS());
    }

    private void linGrayRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new LinGrayCS());
    }

    private void heatedObjectsRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new HeatedObjectCS());
    }

    private void grayRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new GrayCS());
    }

    private void undefinedRadioButtonActionPerformed(ActionEvent evt) {
        this.changeColorScale(new UndefinedCD());
    }

    public static ColorScaleChange getInstance(ProjectionExplorerWeb parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new ColorScaleChange(parent);
        }
        return instance;
    }

    public void show(ProjectionExplorerWeb parent) {
        this.colorTable = this.parent.getGraphPanel().getColorTable();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void changeColorScale(ColorScale scale) {
        this.colorTable.setColorScale(scale);
        float max = (float)this.maxSlider.getValue() / (float)this.maxSlider.getMaximum();
        this.colorTable.getColorScale().setMax(max);
        float min = (float)this.minSlider.getValue() / (float)this.minSlider.getMaximum();
        this.colorTable.getColorScale().setMin(1.0f - min);
        if (this.parent != null) {
            if (this.parent.getGraphPanel() != null) {
                this.parent.getGraphPanel().getViewPanel().colorAs(this.parent.getGraphPanel().getScalarName());
            }
            this.parent.getGraphPanel().cleanImage();
            this.parent.getGraphPanel().repaint();
        }
        this.coloScalePanel.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }
}

