/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.patents;

import java.util.Vector;
import org.horrabin.horrorss.RssItemBean;
import org.horrabin.horrorss.RssParser;
import visualizer.view.SearchPanel;
import visualizer.web.WebElement;
import visualizer.web.patents.PatentsWebElement;
import visualizer.web.patents.USPTOClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatentsGetter {
    private Vector<USPTOClass> links;

    public PatentsGetter(Vector<USPTOClass> links) {
        this.links = links;
    }

    public void executeDownload(SearchPanel rssPanel) {
        this.run(rssPanel);
    }

    private void run(final SearchPanel rssPanel) {
        Thread t = new Thread(){

            public void run() {
                Vector<WebElement> webElements = new Vector<WebElement>();
                rssPanel.setQueryStatus("Retrieving rss patents...", 0);
                int count = 0;
                for (int i = 0; i < PatentsGetter.this.links.size(); ++i) {
                    System.out.println("retrieving: " + ((USPTOClass)PatentsGetter.this.links.get(i)).getLink().trim());
                    RssParser rss = new RssParser(((USPTOClass)PatentsGetter.this.links.get(i)).getLink().trim());
                    rss.parse();
                    Vector items = rss.getItems();
                    for (RssItemBean b : items) {
                        PatentsWebElement pwe = new PatentsWebElement(b, Integer.parseInt(((USPTOClass)PatentsGetter.this.links.get(i)).getUSPTOClass()));
                        if (webElements.contains(pwe)) continue;
                        webElements.add(pwe);
                    }
                    rssPanel.setQueryStatus("Retrieving rss patents...", ++count);
                }
                rssPanel.queryFinished(webElements);
            }
        };
        t.start();
    }
}

