/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.websearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.projection.GraphBuilder;
import visualizer.projection.GraphBuilderListener;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.SearchPanel;
import visualizer.view.ToolConfiguration;
import visualizer.web.WebElement;
import visualizer.web.websearch.WebGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSearchPanel
extends SearchPanel
implements GraphBuilderListener {
    private JLabel numberDocsLabel;
    private JSlider numberDocsSlider;
    private JTextField numberDocumentsTextField;
    private JLabel queryLabel;
    private JTextField queryTextField;
    private JButton searchButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public WebSearchPanel(ProjectionExplorerWeb view) {
        super(view);
        this.initComponents();
        this.numberDocumentsTextField.setText(Integer.toString(this.numberDocsSlider.getValue()));
    }

    private void initComponents() {
        this.queryLabel = new JLabel();
        this.queryTextField = new JTextField();
        this.searchButton = new JButton();
        this.numberDocsLabel = new JLabel();
        this.numberDocsSlider = new JSlider();
        this.numberDocumentsTextField = new JTextField();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusProgressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Parameters of Search"));
        this.queryLabel.setText("Query String");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.queryLabel, gridBagConstraints);
        this.queryTextField.setColumns(30);
        this.queryTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                WebSearchPanel.this.queryTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.queryTextField, gridBagConstraints);
        this.searchButton.setText("Execute");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebSearchPanel.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.searchButton, gridBagConstraints);
        this.numberDocsLabel.setText("Number Documents");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.numberDocsLabel, gridBagConstraints);
        this.numberDocsSlider.setMajorTickSpacing(50);
        this.numberDocsSlider.setMaximum(1000);
        this.numberDocsSlider.setMinimum(10);
        this.numberDocsSlider.setMinorTickSpacing(10);
        this.numberDocsSlider.setPaintTicks(true);
        this.numberDocsSlider.setSnapToTicks(true);
        this.numberDocsSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                WebSearchPanel.this.numberDocsSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.numberDocsSlider, gridBagConstraints);
        this.numberDocumentsTextField.setColumns(5);
        this.numberDocumentsTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                WebSearchPanel.this.numberDocumentsTextFieldFocusLost(evt);
            }
        });
        this.numberDocumentsTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                WebSearchPanel.this.numberDocumentsTextFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.numberDocumentsTextField, gridBagConstraints);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusLabel.setText("status");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusProgressBar.setMaximum(1000);
        this.statusPanel.add((Component)this.statusProgressBar, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusPanel, gridBagConstraints);
    }

    private void numberDocumentsTextFieldFocusLost(FocusEvent evt) {
        int ndocs = Integer.parseInt(this.numberDocumentsTextField.getText());
        if (ndocs < 10) {
            ndocs = 10;
        } else if (ndocs > 1000) {
            ndocs = 1000;
        }
        this.numberDocsSlider.setValue(ndocs);
    }

    private void numberDocumentsTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.numberDocumentsTextFieldFocusLost(null);
        }
    }

    private void numberDocsSliderStateChanged(ChangeEvent evt) {
        this.numberDocumentsTextField.setText(Integer.toString(this.numberDocsSlider.getValue()));
    }

    private void queryTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.searchButtonActionPerformed(null);
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (this.queryTextField.getText().trim().length() > 0) {
            this.statusProgressBar.setValue(0);
            this.statusProgressBar.setMaximum(this.numberDocsSlider.getValue());
            this.searchButton.setEnabled(false);
            WebGetter search = new WebGetter(this.queryTextField.getText(), this.numberDocsSlider.getValue());
            search.executeQuery(this);
        } else {
            JOptionPane.showMessageDialog(this, "A query string must be provided!", "Error", 0);
        }
    }

    @Override
    public void queryFinished(Vector<WebElement> pages) {
        if (pages.size() > 0) {
            Vector<Vertex> vertex = new Vector<Vertex>();
            for (int i = 0; i < pages.size(); ++i) {
                Vertex v = new Vertex(pages.get(i), i);
                vertex.add(v);
            }
            Graph graph = new Graph();
            graph.setVertex(vertex);
            StopwordListManager stpManager = new StopwordListManager();
            stpManager.changeStopwordList("English");
            ArrayList<String> newStps = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.getQuery(), "\t ");
            while (tokenizer.hasMoreTokens()) {
                newStps.add(tokenizer.nextToken().replaceAll("\"", "").trim());
            }
            stpManager.getStopwordListUsed().addStopwords(newStps);
            GraphBuilder builder = new GraphBuilder(graph, stpManager);
            ToolConfiguration tool = ToolConfiguration.getInstance(this.view);
            builder.setFractionDelta(tool.getFracDelta());
            builder.setMatrixType(tool.getMatrixType());
            builder.setMax(tool.getMax());
            builder.setMin(tool.getMin());
            builder.setNrConnections(tool.getNrConnections());
            builder.setNrIterations(tool.getNrIterations());
            builder.setNrNeighbors(tool.getNrNeighbors());
            builder.setNumberGrams(tool.getNrGrams());
            builder.setStemming(tool.isStemming());
            builder.setReducting(tool.isReducing());
            builder.setTargetReduction(tool.getDimensions());
            builder.start(this);
        } else {
            this.statusProgressBar.setValue(0);
            this.searchButton.setEnabled(true);
            JOptionPane.showMessageDialog(this, "None documents were retrieved.\nPlease try another query string.", "Error", 0);
        }
    }

    @Override
    public void projectionFinished(Graph graph, StopwordListManager stpListManager) {
        this.view.addProjection(graph, this, stpListManager);
    }

    @Override
    public void setProjectionStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void setQueryStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public String getQuery() {
        return this.queryTextField.getText();
    }
}

